/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.common.item;

import cy.jdkdigital.everythingcopper.common.item.ICopperItem;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CopperArmorItem
extends ArmorItem
implements ICopperItem {
    public CopperArmorItem(Holder<ArmorMaterial> pMaterial, ArmorItem.Type type, Item.Properties properties) {
        super(pMaterial, type, properties);
    }

    @NotNull
    public Component getName(ItemStack stack) {
        String id = (ICopperItem.isWaxed(stack) ? "waxed_" : "") + ICopperItem.getAge(stack).toLowerCase() + "_copper_";
        return Component.translatable((String)this.getDescriptionId(stack).replace("copper_", id));
    }

    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.inventoryTick(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (pSlotId >= 36 && pSlotId <= 39) {
            this.weatheringTick(pStack, pLevel);
        }
    }

    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        String id = ICopperItem.getAge(stack).toLowerCase() + "_copper_";
        int layerNum = slot.equals((Object)EquipmentSlot.LEGS) ? 2 : 1;
        return ResourceLocation.parse((String)String.format("everythingcopper:textures/models/armor/%slayer_%d.png", id, layerNum));
    }
}

