/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.common.entity;

import cy.jdkdigital.everythingcopper.common.entity.CopperGolem;
import cy.jdkdigital.everythingcopper.util.WeatheringUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.WeatheringCopper;

public interface IWeatheringEntity {
    public static final EntityDataAccessor<String> DATA_WEATHER_STATE = SynchedEntityData.defineId(CopperGolem.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Boolean> DATA_WAXED = SynchedEntityData.defineId(CopperGolem.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public SynchedEntityData getSyncData();

    default public WeatheringCopper.WeatherState getAge() {
        return WeatheringCopper.WeatherState.valueOf((String)((String)this.getSyncData().get(DATA_WEATHER_STATE)));
    }

    default public void setAge(WeatheringCopper.WeatherState age) {
        this.getSyncData().set(DATA_WEATHER_STATE, (Object)age.name());
    }

    default public boolean isWaxed() {
        return (Boolean)this.getSyncData().get(DATA_WAXED);
    }

    default public void setWaxed(boolean waxed) {
        this.getSyncData().set(DATA_WAXED, (Object)waxed);
    }

    default public void saveWeatheredState(CompoundTag tag) {
        tag.putString("weathering", (String)this.getSyncData().get(DATA_WEATHER_STATE));
        tag.putBoolean("waxed", ((Boolean)this.getSyncData().get(DATA_WAXED)).booleanValue());
    }

    default public void loadWeatheredState(CompoundTag tag) {
        if (tag.contains("weathering") && !tag.getString("weathering").isEmpty()) {
            this.setAge(WeatheringCopper.WeatherState.valueOf((String)tag.getString("weathering")));
        }
        if (tag.contains("waxed")) {
            this.getSyncData().set(DATA_WAXED, (Object)tag.getBoolean("waxed"));
        }
    }

    default public InteractionResult itemUse(Level level, ItemStack itemStack, Player player, BlockPos pos) {
        if (!this.isWaxed() && itemStack.getItem() instanceof HoneycombItem) {
            if (!level.isClientSide()) {
                this.setWaxed(true);
            }
            if (!player.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
            level.levelEvent(player, 3003, pos.above(), 0);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (itemStack.getItem() instanceof AxeItem) {
            if (this.isWaxed()) {
                if (!level.isClientSide()) {
                    this.setWaxed(false);
                }
                level.playSound(player, pos.above(), SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.levelEvent(player, 3004, pos.above(), 0);
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (!this.getAge().equals((Object)WeatheringCopper.WeatherState.UNAFFECTED)) {
                if (!level.isClientSide()) {
                    this.setAge(WeatheringUtils.prevState(this.getAge()));
                }
                level.playSound(player, pos.above(), SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.levelEvent(player, 3005, pos.above(), 0);
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return InteractionResult.PASS;
    }

    default public float speedModifier() {
        float speedModifier = 1.0f;
        switch (this.getAge()) {
            case UNAFFECTED: {
                speedModifier = 1.1f;
                break;
            }
            case WEATHERED: {
                speedModifier = 0.9f;
                break;
            }
            case OXIDIZED: {
                speedModifier = 0.8f;
            }
        }
        return speedModifier;
    }

    default public boolean canAge() {
        return !this.isWaxed() && !this.getAge().equals((Object)WeatheringCopper.WeatherState.OXIDIZED);
    }
}

