/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.client.render.entity;

import cy.jdkdigital.everythingcopper.common.entity.IWeatheringEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.block.WeatheringCopper;
import org.jetbrains.annotations.NotNull;

public interface ICopperMinecartRenderer {
    public static final ResourceLocation TEXTURE_UNAFFECTED = ResourceLocation.fromNamespaceAndPath((String)"everythingcopper", (String)"textures/entity/copper_minecart/unaffected.png");
    public static final ResourceLocation TEXTURE_EXPOSED = ResourceLocation.fromNamespaceAndPath((String)"everythingcopper", (String)"textures/entity/copper_minecart/exposed.png");
    public static final ResourceLocation TEXTURE_WEATHERED = ResourceLocation.fromNamespaceAndPath((String)"everythingcopper", (String)"textures/entity/copper_minecart/weathered.png");
    public static final ResourceLocation TEXTURE_OXIDIZED = ResourceLocation.fromNamespaceAndPath((String)"everythingcopper", (String)"textures/entity/copper_minecart/oxidized.png");

    default public ResourceLocation textureLocation(@NotNull AbstractMinecart minecart) {
        if (minecart instanceof IWeatheringEntity) {
            IWeatheringEntity weatherableMinecart = (IWeatheringEntity)minecart;
            return switch (weatherableMinecart.getAge()) {
                case WeatheringCopper.WeatherState.EXPOSED -> TEXTURE_EXPOSED;
                case WeatheringCopper.WeatherState.WEATHERED -> TEXTURE_WEATHERED;
                case WeatheringCopper.WeatherState.OXIDIZED -> TEXTURE_OXIDIZED;
                default -> TEXTURE_UNAFFECTED;
            };
        }
        return TEXTURE_UNAFFECTED;
    }
}

