/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.client.render.entity;

import cy.jdkdigital.everythingcopper.common.entity.CopperGolem;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.IronGolemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.level.block.WeatheringCopper;
import org.jetbrains.annotations.NotNull;

public class CopperGolemRenderer
extends IronGolemRenderer {
    private static final ResourceLocation TEXTURE_UNAFFECTED = ResourceLocation.fromNamespaceAndPath((String)"everythingcopper", (String)"textures/entity/copper_golem/unaffected.png");
    private static final ResourceLocation TEXTURE_EXPOSED = ResourceLocation.fromNamespaceAndPath((String)"everythingcopper", (String)"textures/entity/copper_golem/exposed.png");
    private static final ResourceLocation TEXTURE_WEATHERED = ResourceLocation.fromNamespaceAndPath((String)"everythingcopper", (String)"textures/entity/copper_golem/weathered.png");
    private static final ResourceLocation TEXTURE_OXIDIZED = ResourceLocation.fromNamespaceAndPath((String)"everythingcopper", (String)"textures/entity/copper_golem/oxidized.png");

    public CopperGolemRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull IronGolem golem) {
        if (golem instanceof CopperGolem) {
            CopperGolem copperGolem = (CopperGolem)golem;
            return switch (copperGolem.getAge()) {
                case WeatheringCopper.WeatherState.EXPOSED -> TEXTURE_EXPOSED;
                case WeatheringCopper.WeatherState.WEATHERED -> TEXTURE_WEATHERED;
                case WeatheringCopper.WeatherState.OXIDIZED -> TEXTURE_OXIDIZED;
                default -> TEXTURE_UNAFFECTED;
            };
        }
        return super.getTextureLocation(golem);
    }
}

