/*
 * Decompiled with CFR 0.152.
 */
package com.betterchunkloading.mixin;

import com.betterchunkloading.BetterChunkLoading;
import com.betterchunkloading.config.CommonConfiguration;
import com.betterchunkloading.event.EventHandler;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ServerChunkCache.class})
public abstract class ServerChunkCacheMixin {
    @Shadow
    @Final
    public ServerLevel level;
    @Shadow
    @Final
    public ChunkMap chunkMap;

    @Shadow
    @Nullable
    public abstract ChunkHolder getVisibleChunkIfPresent(long var1);

    @Shadow
    protected abstract CompletableFuture<ChunkResult<ChunkAccess>> getChunkFutureMainThread(int var1, int var2, ChunkStatus var3, boolean var4);

    @Redirect(method={"getChunk"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerChunkCache;getChunkFutureMainThread(IILnet/minecraft/world/level/chunk/status/ChunkStatus;Z)Ljava/util/concurrent/CompletableFuture;"))
    private CompletableFuture<ChunkResult<ChunkAccess>> prioWaiting(ServerChunkCache instance, int x, int z, ChunkStatus status, boolean load) {
        CompletableFuture<ChunkResult<ChunkAccess>> future = this.getChunkFutureMainThread(x, z, status, load);
        if (future == ChunkHolder.UNLOADED_CHUNK_FUTURE) {
            return future;
        }
        if (!future.isDone() && ((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).optimizeWaiting) {
            if (load) {
                ChunkHolder chunkholder = this.getVisibleChunkIfPresent(ChunkPos.asLong((int)x, (int)z));
                EventHandler.loadingChunk = chunkholder.getPos();
                chunkholder.futures.set(status.getIndex(), null);
                CompletableFuture newFuture = chunkholder.scheduleChunkGenerationTask(status, this.chunkMap);
                chunkholder.futures.set(status.getIndex(), future);
                chunkholder.onLevelChange.onLevelChange(chunkholder.getPos(), () -> chunkholder.getQueueLevel(), 1, arg_0 -> ((ChunkHolder)chunkholder).setQueueLevel(arg_0));
                return (CompletableFuture)CompletableFuture.anyOf(future, newFuture).whenComplete((a, b) -> {
                    if (!future.isDone() || future.getNow(ChunkHolder.UNLOADED_CHUNK) != a) {
                        future.complete((ChunkResult)a);
                        chunkholder.addSaveDependency(future);
                    }
                });
            }
            return ChunkHolder.UNLOADED_CHUNK_FUTURE;
        }
        return future;
    }
}

