/*
 * Decompiled with CFR 0.152.
 */
package com.betterchunkloading.mixin;

import com.betterchunkloading.BetterChunkLoading;
import com.betterchunkloading.config.CommonConfiguration;
import com.betterchunkloading.event.EventHandler;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.server.level.ChunkTaskPriorityQueue;
import net.minecraft.world.level.ChunkPos;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkTaskPriorityQueue.class})
public abstract class ChunkTaskPriorityQueueMixin<T> {
    @Shadow
    @Final
    private List<Long2ObjectLinkedOpenHashMap<List<Optional<T>>>> taskQueue;
    @Shadow
    private volatile int firstQueue;

    @Redirect(method={"resortChunkTasks"}, at=@At(value="INVOKE", target="Ljava/util/List;addAll(Ljava/util/Collection;)Z"))
    private boolean newTasksFirst(List instance, Collection es, int p_140522_, ChunkPos p_140523_, int p_140524_) {
        return instance.addAll(0, es);
    }

    @Inject(method={"resortChunkTasks"}, at={@At(value="RETURN")})
    private void checkStalled(int p_140522_, ChunkPos chunkPos, int p_140524_, CallbackInfo ci) {
        if (EventHandler.loadingChunk != null && this.firstQueue > 1 && ((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).optimizeWaiting) {
            long longPos = chunkPos.toLong();
            ArrayList newTaskList = null;
            for (int index = 0; index < this.taskQueue.size(); ++index) {
                Long2ObjectLinkedOpenHashMap<List<Optional<T>>> map = this.taskQueue.get(index);
                List data = (List)map.get(longPos);
                if (data == null || data.isEmpty()) continue;
                if (newTaskList == null) {
                    newTaskList = new ArrayList();
                }
                newTaskList.addAll(data);
                map.remove(longPos);
            }
            if (newTaskList != null) {
                this.firstQueue = 1;
                ((List)this.taskQueue.get(1).computeIfAbsent(longPos, s -> new ArrayList())).addAll(0, newTaskList);
            }
        }
    }

    @Redirect(method={"submit"}, at=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z"))
    private boolean submitNewTasksFirst(List instance, Object e, Optional<T> p_140536_, long pos, int p_140538_) {
        instance.add(0, e);
        return true;
    }
}

