/*
 * Decompiled with CFR 0.152.
 */
package com.betterchunkloading.config;

import com.cupboard.config.ICommonConfig;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class CommonConfiguration
implements ICommonConfig {
    public static boolean convertWaterSource = true;
    public static boolean convertLavaSource = false;
    public boolean enablePrediction = true;
    public int predictionarea = 7;
    public boolean enableSmartChunkLoading = true;
    public double smartChunkLoadingSpeed = 1.0;
    public double predictionLoadingSpeed = 1.0;
    public boolean enableFasterChunkTasks = false;
    public boolean optimizeWaiting = true;
    public boolean enableSmartPostProcessing = true;
    public boolean debugLogging = false;
    public boolean preventWalkUnloaded = true;

    public JsonObject serialize() {
        JsonObject root = new JsonObject();
        JsonObject entry3 = new JsonObject();
        entry3.addProperty("desc:", "Enables predictive chunkloading, which predicts player movement and preloads an area in movement direction: default:true");
        entry3.addProperty("enablePrediction", Boolean.valueOf(this.enablePrediction));
        root.add("enablePrediction", (JsonElement)entry3);
        JsonObject entry12 = new JsonObject();
        entry12.addProperty("desc:", "Set a modifier to prediction area loading speed, increasing the value increases the speed at which chunks load around the player. Note that faster loading also means higher impact on TPS. range: [0.01 -> 10.0], default: 1.0");
        entry12.addProperty("predictionLoadingSpeed", (Number)this.predictionLoadingSpeed);
        root.add("predictionLoadingSpeed", (JsonElement)entry12);
        JsonObject entry2 = new JsonObject();
        entry2.addProperty("desc:", "Size of the area marked for preloading: default:7 chunks, max: 32, min: 2");
        entry2.addProperty("predictionarea", (Number)this.predictionarea);
        root.add("predictionarea", (JsonElement)entry2);
        JsonObject entry5 = new JsonObject();
        entry5.addProperty("desc:", "Enables smart chunkloading around the player, which dynamically loads the around the player : default:true");
        entry5.addProperty("enableSmartChunkLoading", Boolean.valueOf(this.enableSmartChunkLoading));
        root.add("enableSmartChunkLoading", (JsonElement)entry5);
        JsonObject entry13 = new JsonObject();
        entry13.addProperty("desc:", "Set a modifier to smart chunkloading speed, increasing the value increases the speed at which chunks load around the player. Note that faster loading also means higher impact on TPS. range: [0.01 -> 10.0], default: 1.0");
        entry13.addProperty("smartChunkLoadingSpeed", (Number)this.smartChunkLoadingSpeed);
        root.add("smartChunkLoadingSpeed", (JsonElement)entry13);
        JsonObject entry11 = new JsonObject();
        entry11.addProperty("desc:", "Prevents players from moving into unloaded areas on serverside, which stalls the server and forceloads the chunk: default:true");
        entry11.addProperty("preventWalkUnloaded", Boolean.valueOf(this.preventWalkUnloaded));
        root.add("preventWalkUnloaded", (JsonElement)entry11);
        JsonObject entry7 = new JsonObject();
        entry7.addProperty("desc:", "Enables smart post processing, which slightly improves the general chunk loading speed by waiting with post processing(e.g. fluid updates) until neighbouring chunks are loaded: default:true");
        entry7.addProperty("enableSmartPostProcessing", Boolean.valueOf(this.enableSmartPostProcessing));
        root.add("enableSmartPostProcessing", (JsonElement)entry7);
        JsonObject ENTRY9 = new JsonObject();
        ENTRY9.addProperty("desc:", "Enables faster worldgen tasks: default:false");
        ENTRY9.addProperty("enableFasterChunkTasks", Boolean.valueOf(this.enableFasterChunkTasks));
        root.add("enableFasterChunkTasks", (JsonElement)ENTRY9);
        JsonObject entry09 = new JsonObject();
        entry09.addProperty("desc:", "Optimizes time the world is stalled while waiting for a chunk: default:true");
        entry09.addProperty("optimizeWaiting", Boolean.valueOf(this.optimizeWaiting));
        root.add("optimizeWaiting", (JsonElement)entry09);
        JsonObject entry8 = new JsonObject();
        entry8.addProperty("desc:", "Enables debug logging to show chunk loading changes: default:false");
        entry8.addProperty("debugLogging", Boolean.valueOf(this.debugLogging));
        root.add("debugLogging", (JsonElement)entry8);
        return root;
    }

    public void deserialize(JsonObject data) {
        this.predictionarea = Math.max(2, Math.min(32, data.get("predictionarea").getAsJsonObject().get("predictionarea").getAsInt()));
        this.enablePrediction = data.get("enablePrediction").getAsJsonObject().get("enablePrediction").getAsBoolean();
        this.enableSmartChunkLoading = data.get("enableSmartChunkLoading").getAsJsonObject().get("enableSmartChunkLoading").getAsBoolean();
        this.enableSmartPostProcessing = data.get("enableSmartPostProcessing").getAsJsonObject().get("enableSmartPostProcessing").getAsBoolean();
        this.enableFasterChunkTasks = data.get("enableFasterChunkTasks").getAsJsonObject().get("enableFasterChunkTasks").getAsBoolean();
        this.preventWalkUnloaded = data.get("preventWalkUnloaded").getAsJsonObject().get("preventWalkUnloaded").getAsBoolean();
        this.optimizeWaiting = data.get("optimizeWaiting").getAsJsonObject().get("optimizeWaiting").getAsBoolean();
        this.smartChunkLoadingSpeed = Math.min(10.0, Math.max(0.01, data.get("smartChunkLoadingSpeed").getAsJsonObject().get("smartChunkLoadingSpeed").getAsDouble()));
        this.predictionLoadingSpeed = Math.min(10.0, Math.max(0.01, data.get("predictionLoadingSpeed").getAsJsonObject().get("predictionLoadingSpeed").getAsDouble()));
        this.debugLogging = data.get("debugLogging").getAsJsonObject().get("debugLogging").getAsBoolean();
    }
}

