/*
 * Decompiled with CFR 0.152.
 */
package com.betterchunkloading;

import com.betterchunkloading.BetterChunkLoading;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.SortedArraySet;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;

public class Command {
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"betterchunkloading").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(Commands.literal((String)"printPlayerTicks").executes(context -> {
            Command.printPlayerTickets((CommandSourceStack)context.getSource());
            return 1;
        }))).then(Commands.literal((String)"setviewdist").then(Commands.argument((String)"distance", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int viewDist = IntegerArgumentType.getInteger((CommandContext)context, (String)"distance");
            ((CommandSourceStack)context.getSource()).getLevel().getChunkSource().setViewDistance(viewDist);
            return 1;
        })))).then(Commands.literal((String)"genChunkAt").then(Commands.argument((String)"position", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> {
            BlockPos viewDist = BlockPosArgument.getBlockPos((CommandContext)context, (String)"position");
            ChunkPos currentChunk = new ChunkPos(viewDist.getX() >> 4, viewDist.getZ() >> 4);
            RegionFileStorage storage = ((IOWorker)((CommandSourceStack)context.getSource()).getLevel().getChunkSource().chunkMap.chunkScanner()).storage;
            CompletableFuture future = ((IOWorker)((CommandSourceStack)context.getSource()).getLevel().getChunkSource().chunkMap.chunkScanner()).submitTask(() -> {
                ArrayList<ChunkPos> missing = new ArrayList<ChunkPos>();
                for (int i = -10; i < 10; ++i) {
                    for (int j = -10; j < 10; ++j) {
                        if (Math.sqrt(i * i + j * j) > 20.0) continue;
                        ChunkPos current = new ChunkPos(currentChunk.x + i, currentChunk.z + j);
                        try {
                            if (storage.getRegionFile(current).hasChunk(current)) continue;
                            missing.add(current);
                            continue;
                        }
                        catch (IOException e) {
                            missing.add(current);
                        }
                    }
                }
                return Either.left(missing);
            });
            future.thenApplyAsync(list -> {
                for (ChunkPos pos : list) {
                    ((CommandSourceStack)context.getSource()).getLevel().getChunkSource().chunkMap.getDistanceManager().addTicket(TicketType.UNKNOWN, pos, ChunkLevel.byStatus((ChunkStatus)ChunkStatus.FULL), (Object)pos);
                }
                BetterChunkLoading.LOGGER.warn("Adding tickets to:" + list.size() + " chunks");
                ((CommandSourceStack)context.getSource()).getLevel().getChunkSource().runDistanceManagerUpdates();
                return null;
            }, (Executor)((CommandSourceStack)context.getSource()).getServer());
            return 1;
        })))).then(Commands.literal((String)"loadchunk").then(Commands.argument((String)"position", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> {
            ChunkPos chunkPos = new ChunkPos(BlockPosArgument.getBlockPos((CommandContext)context, (String)"position"));
            ((CommandSourceStack)context.getSource()).getLevel().getChunk(chunkPos.x, chunkPos.z);
            return 1;
        })))).then(Commands.literal((String)"setsimdist").then(Commands.argument((String)"distance", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int viewDist = IntegerArgumentType.getInteger((CommandContext)context, (String)"distance");
            ((CommandSourceStack)context.getSource()).getLevel().getChunkSource().setSimulationDistance(viewDist);
            return 1;
        })));
    }

    public static void printPlayerTickets(CommandSourceStack commandSourceStack) {
        for (ServerLevel level : commandSourceStack.getServer().getAllLevels()) {
            level.getChunkSource().distanceManager.runAllUpdates(level.getChunkSource().chunkMap);
            int playerTickets = 0;
            for (Long2ObjectMap.Entry entry : level.getChunkSource().distanceManager.tickets.long2ObjectEntrySet()) {
                for (Ticket ticket : (SortedArraySet)entry.getValue()) {
                    if (ticket == null || ticket.getType() != TicketType.PLAYER) continue;
                    ++playerTickets;
                }
            }
            commandSourceStack.sendSystemMessage((Component)Component.literal((String)("Dimension:" + level.dimension().location().toString())));
            commandSourceStack.sendSystemMessage((Component)Component.literal((String)("Player tickets(viewdistance):" + playerTickets)));
            BetterChunkLoading.LOGGER.warn("Dimension:" + level.dimension().location().toString());
            BetterChunkLoading.LOGGER.warn("Player tickets(viewdistance):" + playerTickets);
            playerTickets = 0;
            for (Long2ObjectMap.Entry entry : level.getChunkSource().distanceManager.tickingTicketsTracker.tickets.long2ObjectEntrySet()) {
                for (Ticket ticket : (SortedArraySet)entry.getValue()) {
                    if (ticket == null || ticket.getType() != TicketType.PLAYER) continue;
                    ++playerTickets;
                }
            }
            commandSourceStack.sendSystemMessage((Component)Component.literal((String)("Player ticking(sim distance) tickets:" + playerTickets)));
            BetterChunkLoading.LOGGER.warn("Player ticking(sim distance) tickets:" + playerTickets);
        }
    }
}

