/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.almanac.command;

import com.frikinjay.almanac.Almanac;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class ReloadCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"almanac").requires(source -> source.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal((String)"reload").then(Commands.argument((String)"config", (ArgumentType)StringArgumentType.string()).suggests(ReloadCommand::suggestConfigs).executes(ReloadCommand::reloadConfig))).executes(ReloadCommand::listConfigs)));
    }

    private static CompletableFuture<Suggestions> suggestConfigs(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        String remaining = builder.getRemaining().toLowerCase();
        Almanac.getConfigEntryNames().stream().filter(config -> config.toLowerCase().startsWith(remaining)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static int listConfigs(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Available configs:"), false);
        Almanac.getConfigEntryNames().forEach(configName -> ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("- " + configName)), false));
        return 1;
    }

    private static int reloadConfig(CommandContext<CommandSourceStack> context) {
        String configName = StringArgumentType.getString(context, (String)"config");
        try {
            Almanac.reloadConfig(configName);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Reloaded and repopulated config: " + configName)), true);
        }
        catch (Exception e) {
            Almanac.LOGGER.error("Error reloading config: " + configName, (Throwable)e);
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Error reloading config: " + configName + ". Check the server logs for details.")));
        }
        return 1;
    }
}

