/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class NBTUtils {
    public static Tag convertJsonToTag(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            JsonPrimitive primitive = jsonElement.getAsJsonPrimitive();
            if (primitive.isString()) {
                return StringTag.valueOf((String)primitive.getAsString());
            }
            if (primitive.isNumber()) {
                return DoubleTag.valueOf((double)primitive.getAsDouble());
            }
            if (primitive.isBoolean()) {
                return ByteTag.valueOf((boolean)primitive.getAsBoolean());
            }
        } else {
            if (jsonElement.isJsonArray()) {
                JsonArray array = jsonElement.getAsJsonArray();
                ListTag list = new ListTag();
                array.forEach(element -> list.add((Object)NBTUtils.convertJsonToTag(element)));
                return list;
            }
            if (jsonElement.isJsonObject()) {
                CompoundTag compound = new CompoundTag();
                JsonObject object = jsonElement.getAsJsonObject();
                object.entrySet().forEach(entry -> compound.put((String)entry.getKey(), NBTUtils.convertJsonToTag((JsonElement)entry.getValue())));
                return compound;
            }
        }
        return null;
    }

    public static JsonElement convertTagToJson(Tag tag) {
        if (tag instanceof StringTag) {
            return new JsonPrimitive(tag.getAsString());
        }
        if (tag instanceof DoubleTag) {
            return new JsonPrimitive((Number)((DoubleTag)tag).getAsDouble());
        }
        if (tag instanceof ByteTag) {
            ByteTag byteTag = (ByteTag)tag;
            return new JsonPrimitive(Boolean.valueOf(byteTag == ByteTag.ONE));
        }
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            JsonObject object = new JsonObject();
            compoundTag.getAllKeys().forEach(key -> object.add(key, NBTUtils.convertTagToJson(compoundTag.get(key))));
            return object;
        }
        if (tag instanceof ListTag) {
            ListTag listTag = (ListTag)tag;
            JsonArray array = new JsonArray();
            listTag.forEach(element -> array.add(NBTUtils.convertTagToJson(element)));
            return array;
        }
        return null;
    }
}

