/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.platform;

import com.mojang.logging.LogUtils;
import java.util.ServiceLoader;
import me.pandamods.pandalib.platform.services.GameHelper;
import me.pandamods.pandalib.platform.services.ModLoaderHelper;
import me.pandamods.pandalib.platform.services.NetworkHelper;
import me.pandamods.pandalib.platform.services.RegistrationHelper;
import org.slf4j.Logger;

public class Services {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final NetworkHelper NETWORK = Services.load(NetworkHelper.class);
    public static final RegistrationHelper REGISTRATION = Services.load(RegistrationHelper.class);
    public static final GameHelper GAME = Services.load(GameHelper.class);
    public static final ModLoaderHelper MOD_LOADER = Services.load(ModLoaderHelper.class);

    private static <T> T load(Class<T> serviceClass) {
        T loadedService = ServiceLoader.load(serviceClass).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + serviceClass.getName()));
        LOGGER.debug("Loaded {} for service {}", loadedService, serviceClass);
        return loadedService;
    }
}

