/*
 * Decompiled with CFR 0.152.
 */
package me.pandamods.pandalib.core.network;

import me.pandamods.pandalib.config.ConfigData;
import me.pandamods.pandalib.config.PandaLibConfig;
import me.pandamods.pandalib.config.holders.ClientConfigHolder;
import me.pandamods.pandalib.config.holders.CommonConfigHolder;
import me.pandamods.pandalib.core.network.ConfigCodec;
import me.pandamods.pandalib.core.network.packets.ConfigPacketData;
import me.pandamods.pandalib.networking.NetworkContext;
import me.pandamods.pandalib.networking.NetworkRegistry;
import me.pandamods.pandalib.networking.PacketDistributor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class ConfigNetworking {
    public static void registerPackets(NetworkRegistry registry) {
        registry.registerBiDirectionalReceiver(ConfigPacketData.TYPE, ConfigCodec.INSTANCE, ConfigNetworking::CommonConfigReceiver, ConfigNetworking::ClientConfigReceiver);
    }

    public static void SyncCommonConfigs(ServerPlayer serverPlayer) {
        PandaLibConfig.getConfigs().values().stream().filter(configHolder -> configHolder instanceof CommonConfigHolder && configHolder.shouldSynchronize()).forEach(configHolder -> ConfigNetworking.SyncCommonConfig(serverPlayer, (CommonConfigHolder)configHolder));
    }

    public static void SyncCommonConfig(ServerPlayer serverPlayer, CommonConfigHolder<?> holder) {
        holder.logger.info("Sending common config '{}' to {}", (Object)holder.resourceLocation().toString(), (Object)serverPlayer.getDisplayName().getString());
        PacketDistributor.sendToPlayer(serverPlayer, new ConfigPacketData(holder.resourceLocation(), holder.getGson().toJsonTree(holder.get())));
    }

    public static void SyncClientConfigs() {
        PandaLibConfig.getConfigs().values().stream().filter(configHolder -> configHolder instanceof ClientConfigHolder && configHolder.shouldSynchronize()).forEach(configHolder -> ConfigNetworking.SyncClientConfig((ClientConfigHolder)configHolder));
    }

    public static void SyncClientConfig(ClientConfigHolder<?> holder) {
        holder.logger.info("Sending client config '{}' to server", (Object)holder.resourceLocation().toString());
        PacketDistributor.sendToServer(new ConfigPacketData(holder.resourceLocation(), holder.getGson().toJsonTree(holder.get())));
    }

    private static void ClientConfigReceiver(NetworkContext ctx, ConfigPacketData packetData) {
        ResourceLocation resourceLocation = packetData.resourceLocation();
        PandaLibConfig.getConfig(resourceLocation).ifPresent(configHolder -> {
            if (configHolder instanceof ClientConfigHolder) {
                ClientConfigHolder clientConfigHolder = (ClientConfigHolder)configHolder;
                configHolder.logger.info("Received client config '{}' from {}", (Object)configHolder.resourceLocation().toString(), (Object)ctx.getPlayer().getDisplayName().getString());
                clientConfigHolder.putConfig(ctx.getPlayer(), (ConfigData)configHolder.getGson().fromJson(packetData.data(), configHolder.getConfigClass()));
            }
        });
    }

    private static void CommonConfigReceiver(NetworkContext ctx, ConfigPacketData packetData) {
        ResourceLocation resourceLocation = packetData.resourceLocation();
        PandaLibConfig.getConfig(resourceLocation).ifPresent(configHolder -> {
            if (configHolder instanceof CommonConfigHolder) {
                CommonConfigHolder commonConfigHolder = (CommonConfigHolder)configHolder;
                configHolder.logger.info("Received common config '{}' from server", (Object)configHolder.resourceLocation().toString());
                commonConfigHolder.setCommonConfig((ConfigData)configHolder.getGson().fromJson(packetData.data(), configHolder.getConfigClass()));
            }
        });
    }
}

