/*
 * Decompiled with CFR 0.152.
 */
package com.mcwroofs.kikoz.objects.roofs;

import com.mcwroofs.kikoz.objects.roofs.RoofBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Lower
extends RoofBlock {
    protected static final VoxelShape OCCLUSION = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    protected static final VoxelShape OCCLUSION_BOTTOM = Block.box((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape BASE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape BASE_TOP = Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final EnumProperty<Half> HALF = BlockStateProperties.HALF;

    public Lower(BlockState state, BlockBehaviour.Properties prop) {
        super(prop);
    }

    @Override
    public BlockState updateShape(BlockState state, Direction dir, BlockState statetwo, LevelAccessor access, BlockPos pos, BlockPos postwo) {
        return dir.getAxis().isHorizontal() ? (BlockState)state.setValue((Property)SHAPE, (Comparable)Lower.getStairsShape((BlockGetter)access, pos, (Direction)state.getValue((Property)FACING), (Half)state.getValue(HALF))) : super.updateShape(state, dir, statetwo, access, pos, postwo);
    }

    private static StairsShape getStairsShape(BlockGetter reader, BlockPos pos, Direction facing, Half half) {
        Direction direction2;
        Direction direction1;
        Direction direction = facing;
        BlockState blockstate = reader.getBlockState(pos.relative(direction));
        if (Lower.isLower(blockstate) && half == blockstate.getValue(HALF) && (direction1 = (Direction)blockstate.getValue((Property)FACING)).getAxis() != facing.getAxis() && Lower.canTakeShape(direction1.getOpposite(), blockstate, reader, pos)) {
            return direction1 == direction.getCounterClockWise() ? StairsShape.OUTER_LEFT : StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = reader.getBlockState(pos.relative(direction.getOpposite()));
        if (Lower.isLower(blockstate1) && half == blockstate1.getValue(HALF) && (direction2 = (Direction)blockstate1.getValue((Property)FACING)).getAxis() != facing.getAxis() && Lower.canTakeShape(direction2, blockstate1, reader, pos)) {
            return direction2 == direction.getCounterClockWise() ? StairsShape.INNER_LEFT : StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean canTakeShape(Direction dir, BlockState state, BlockGetter reader, BlockPos pos) {
        BlockState blockstate = reader.getBlockState(pos.relative(dir));
        return !Lower.isLower(blockstate) || blockstate.getValue((Property)FACING) != state.getValue((Property)FACING) || blockstate.getValue(HALF) != state.getValue(HALF);
    }

    public static boolean isLower(BlockState state) {
        return state.getBlock() instanceof Lower;
    }

    @Override
    public VoxelShape getOcclusionShape(BlockState state, BlockGetter getter, BlockPos pos) {
        if (state.getValue(HALF) == Half.BOTTOM) {
            return OCCLUSION;
        }
        return OCCLUSION_BOTTOM;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext sel) {
        if (state.getValue(HALF) == Half.TOP) {
            return BASE_TOP;
        }
        return BASE;
    }
}

