/*
 * Decompiled with CFR 0.152.
 */
package com.mcwroofs.kikoz.objects.gutters;

import com.mcwroofs.kikoz.init.ItemInit;
import com.mcwroofs.kikoz.objects.roofs.AwningBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RainGutter
extends AwningBlock {
    private static final BooleanProperty WATER = BooleanProperty.create((String)"water");
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Shapes.empty(), Shapes.empty(), Block.box((double)0.0, (double)10.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0), Block.box((double)0.0, (double)10.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)10.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0), Block.box((double)0.0, (double)10.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0), Block.box((double)8.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), Block.box((double)8.0, (double)10.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)8.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), Block.box((double)8.0, (double)10.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0)};
    protected static final VoxelShape[] BOTTOM_SHAPES = RainGutter.createStairShapes(SHAPES[1], SHAPES[4], SHAPES[8], SHAPES[5], SHAPES[9]);
    private static final int[] SHAPE_BY_STATE = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};

    private static VoxelShape[] createStairShapes(VoxelShape baseShape, VoxelShape ... shapes) {
        VoxelShape[] stairShapes = new VoxelShape[16];
        for (int i = 0; i < 16; ++i) {
            stairShapes[i] = baseShape;
            for (int j = 0; j < shapes.length; ++j) {
                if ((i & 1 << j) == 0) continue;
                stairShapes[i] = Shapes.or((VoxelShape)stairShapes[i], (VoxelShape)shapes[j]);
            }
        }
        return stairShapes;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext collision) {
        VoxelShape[] shapes = BOTTOM_SHAPES;
        int shapeIndex = this.getShapeIndex(state);
        return shapes[SHAPE_BY_STATE[shapeIndex]];
    }

    private int getShapeIndex(BlockState state) {
        return ((StairsShape)state.getValue((Property)SHAPE)).ordinal() * 4 + ((Direction)state.getValue((Property)FACING)).get2DDataValue();
    }

    public RainGutter(BlockState state, BlockBehaviour.Properties prop) {
        super(state, prop);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATER, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)SHAPE, (Comparable)StairsShape.STRAIGHT));
    }

    protected ItemInteractionResult useItemOn(ItemStack itemstack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Item item = itemstack.getItem();
        Boolean i = (Boolean)state.getValue((Property)WATER);
        if (item == ItemInit.ROOFING_HAMMER.get()) {
            state = (BlockState)state.cycle((Property)SHAPE);
            world.setBlock(pos, state, 2);
        }
        if (item == Items.WATER_BUCKET && !i.booleanValue()) {
            state = (BlockState)state.cycle((Property)WATER);
            world.setBlock(pos, state, 2);
            player.setItemInHand(hand, new ItemStack((ItemLike)Items.BUCKET));
        }
        if (item == Items.BUCKET && i.booleanValue()) {
            state = (BlockState)state.cycle((Property)WATER);
            world.setBlock(pos, state, 2);
            itemstack.shrink(1);
            player.setItemInHand(hand, new ItemStack((ItemLike)Items.WATER_BUCKET));
        }
        if (item == Items.GLASS_BOTTLE && i.booleanValue()) {
            state = (BlockState)state.cycle((Property)WATER);
            world.setBlock(pos, state, 2);
            player.setItemInHand(hand, new ItemStack((ItemLike)Items.POTION));
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static boolean isBlockStairs(BlockState state) {
        return state.getBlock() instanceof RainGutter;
    }

    protected boolean isRainingday(Level world, BlockPos pos) {
        return world.isRainingAt(pos);
    }

    public boolean isRandomlyTicking(BlockState state) {
        if (((Boolean)state.getValue((Property)WATER)).booleanValue()) {
            // empty if block
        }
        return true;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        BlockPos blockpos = pos.above(30);
        if (world.isRainingAt(blockpos) && !((Boolean)state.getValue((Property)WATER)).booleanValue()) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)WATER, (Comparable)Boolean.valueOf(true)));
        }
        if (!world.isRainingAt(blockpos) && ((Boolean)state.getValue((Property)WATER)).booleanValue()) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)WATER, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATER, FACING, SHAPE});
    }
}

