/*
 * Decompiled with CFR 0.152.
 */
package dev.compasses.expandedstorage.inventory;

import dev.compasses.expandedstorage._UtilsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\"\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J \u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u001d\u001a\u00020\u0013H\u0016J\b\u0010\u001e\u001a\u00020\u0019H\u0016J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0013H\u0016J\u0018\u0010 \u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u0013H\u0016J\u0010\u0010\"\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0013H\u0016J\u0018\u0010#\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0004H\u0016J\b\u0010$\u001a\u00020\fH\u0016R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006%"}, d2={"Ldev/compasses/expandedstorage/inventory/ExposedInventory;", "Lnet/minecraft/world/WorldlyContainer;", "items", "Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/item/ItemStack;", "getItems", "()Lnet/minecraft/core/NonNullList;", "slots", "", "getSlots", "()[I", "loadInventoryFromTag", "", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "saveInventoryToTag", "replaceInventory", "", "replacement", "getSlotsForFace", "face", "Lnet/minecraft/core/Direction;", "canPlaceItemThroughFace", "", "slot", "stack", "canTakeItemThroughFace", "getContainerSize", "isEmpty", "getItem", "removeItem", "amount", "removeItemNoUpdate", "setItem", "clearContent", "expandedstorage-neoforge-1.21.1"})
public interface ExposedInventory
extends WorldlyContainer {
    @NotNull
    public NonNullList<ItemStack> getItems();

    @NotNull
    public int[] getSlots();

    public void loadInventoryFromTag(@NotNull CompoundTag var1, @NotNull HolderLookup.Provider var2);

    public void saveInventoryToTag(@NotNull CompoundTag var1, @NotNull HolderLookup.Provider var2);

    public int replaceInventory(@NotNull NonNullList<ItemStack> var1);

    @NotNull
    public int[] getSlotsForFace(@NotNull Direction var1);

    public boolean canPlaceItemThroughFace(int var1, @NotNull ItemStack var2, @Nullable Direction var3);

    public boolean canTakeItemThroughFace(int var1, @NotNull ItemStack var2, @NotNull Direction var3);

    public int getContainerSize();

    public boolean isEmpty();

    @NotNull
    public ItemStack getItem(int var1);

    @NotNull
    public ItemStack removeItem(int var1, int var2);

    @NotNull
    public ItemStack removeItemNoUpdate(int var1);

    public void setItem(int var1, @NotNull ItemStack var2);

    public void clearContent();

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nExposedInventory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExposedInventory.kt\ndev/compasses/expandedstorage/inventory/ExposedInventory$DefaultImpls\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1734#2,3:81\n*S KotlinDebug\n*F\n+ 1 ExposedInventory.kt\ndev/compasses/expandedstorage/inventory/ExposedInventory$DefaultImpls\n*L\n52#1:81,3\n*E\n"})
    public static final class DefaultImpls {
        @NotNull
        public static int[] getSlots(@NotNull ExposedInventory $this) {
            int n = 0;
            int n2 = $this.getContainerSize();
            int[] nArray = new int[n2];
            while (n < n2) {
                int n3;
                nArray[n3] = n3 = n++;
            }
            return nArray;
        }

        public static void loadInventoryFromTag(@NotNull ExposedInventory $this, @NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
            ContainerHelper.loadAllItems((CompoundTag)tag, $this.getItems(), (HolderLookup.Provider)registries);
        }

        public static void saveInventoryToTag(@NotNull ExposedInventory $this, @NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
            ContainerHelper.saveAllItems((CompoundTag)tag, $this.getItems(), (HolderLookup.Provider)registries);
        }

        public static int replaceInventory(@NotNull ExposedInventory $this, @NotNull NonNullList<ItemStack> replacement) {
            Intrinsics.checkNotNullParameter(replacement, (String)"replacement");
            $this.getItems().clear();
            int size = Math.min($this.getItems().size(), replacement.size());
            for (int i = 0; i < size; ++i) {
                Object object = replacement.get(i);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                ItemStack stack = (ItemStack)object;
                if (!_UtilsKt.isNotEmpty(stack)) continue;
                $this.getItems().set(i, (Object)stack);
            }
            return size;
        }

        @NotNull
        public static int[] getSlotsForFace(@NotNull ExposedInventory $this, @NotNull Direction face) {
            Intrinsics.checkNotNullParameter((Object)face, (String)"face");
            return $this.getSlots();
        }

        public static boolean canPlaceItemThroughFace(@NotNull ExposedInventory $this, int slot, @NotNull ItemStack stack, @Nullable Direction face) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return true;
        }

        public static boolean canTakeItemThroughFace(@NotNull ExposedInventory $this, int slot, @NotNull ItemStack stack, @NotNull Direction face) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)face, (String)"face");
            return true;
        }

        public static int getContainerSize(@NotNull ExposedInventory $this) {
            return $this.getItems().size();
        }

        public static boolean isEmpty(@NotNull ExposedInventory $this) {
            boolean bl;
            block3: {
                Iterable $this$all$iv = (Iterable)$this.getItems();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        ItemStack it = (ItemStack)element$iv;
                        boolean bl2 = false;
                        if (it.isEmpty()) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        @NotNull
        public static ItemStack getItem(@NotNull ExposedInventory $this, int slot) {
            Object object = $this.getItems().get(slot);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return (ItemStack)object;
        }

        @NotNull
        public static ItemStack removeItem(@NotNull ExposedInventory $this, int slot, int amount) {
            ItemStack stack = ContainerHelper.removeItem((List)((List)$this.getItems()), (int)slot, (int)amount);
            Intrinsics.checkNotNull((Object)stack);
            if (_UtilsKt.isNotEmpty(stack)) {
                $this.setChanged();
            }
            return stack;
        }

        @NotNull
        public static ItemStack removeItemNoUpdate(@NotNull ExposedInventory $this, int slot) {
            ItemStack itemStack = ContainerHelper.takeItem((List)((List)$this.getItems()), (int)slot);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"takeItem(...)");
            return itemStack;
        }

        public static void setItem(@NotNull ExposedInventory $this, int slot, @NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            if (stack.getCount() > $this.getMaxStackSize()) {
                stack.setCount($this.getMaxStackSize());
            }
            $this.getItems().set(slot, (Object)stack);
            $this.setChanged();
        }

        public static void clearContent(@NotNull ExposedInventory $this) {
            $this.getItems().clear();
        }
    }
}

