/*
 * Decompiled with CFR 0.152.
 */
package dev.compasses.expandedstorage.entity;

import compasses.expandedstorage.impl.block.ChestBlock;
import compasses.expandedstorage.impl.client.helpers.InventoryOpeningApi;
import compasses.expandedstorage.impl.inventory.OpenableInventory;
import compasses.expandedstorage.impl.inventory.OpenableInventoryProvider;
import compasses.expandedstorage.impl.inventory.context.BaseContext;
import dev.compasses.expandedstorage._UtilsKt;
import dev.compasses.expandedstorage.inventory.ExposedInventory;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 C2\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u00032\u00020\u0005:\u0001CB+\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010 \u001a\u00020\u000bH\u0014J\b\u0010!\u001a\u00020\u0012H\u0016J\b\u0010\"\u001a\u00020\u0016H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u0004H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020*2\u0006\u0010+\u001a\u000200H\u0016J\b\u00101\u001a\u00020\u001aH\u0016J\b\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020.2\u0006\u00105\u001a\u000206H\u0014J\u0010\u00107\u001a\u00020.2\u0006\u00105\u001a\u000206H\u0014J\u0018\u00108\u001a\u0002092\u0006\u0010+\u001a\u0002002\u0006\u0010:\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020.2\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020.2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010@\u001a\u00020.2\u0006\u0010A\u001a\u00020BH\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u001b\u0010\u0019\u001a\n \u0017*\u0004\u0018\u00010\u001a0\u001a\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\u001b\u0010\u001cR\u0018\u0010\u001e\u001a\n \u0017*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001f\u00a8\u0006D"}, d2={"Ldev/compasses/expandedstorage/entity/ChestMinecart;", "Lnet/minecraft/world/entity/vehicle/AbstractMinecart;", "Ldev/compasses/expandedstorage/inventory/ExposedInventory;", "Lcompasses/expandedstorage/impl/inventory/OpenableInventoryProvider;", "Lcompasses/expandedstorage/impl/inventory/context/BaseContext;", "Lcompasses/expandedstorage/impl/inventory/OpenableInventory;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "dropItem", "Lnet/minecraft/world/item/Item;", "block", "Lcompasses/expandedstorage/impl/block/ChestBlock;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/Item;Lcompasses/expandedstorage/impl/block/ChestBlock;)V", "items", "Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/item/ItemStack;", "getItems", "()Lnet/minecraft/core/NonNullList;", "renderState", "Lnet/minecraft/world/level/block/state/BlockState;", "kotlin.jvm.PlatformType", "Lnet/minecraft/world/level/block/state/BlockState;", "title", "Lnet/minecraft/network/chat/Component;", "getTitle", "()Lnet/minecraft/network/chat/Component;", "Lnet/minecraft/network/chat/Component;", "chestItem", "Lnet/minecraft/world/item/Item;", "getDropItem", "getPickResult", "getDisplayBlockState", "getDefaultDisplayOffset", "", "getInventory", "Lnet/minecraft/world/WorldlyContainer;", "getOpenableInventory", "context", "canBeUsedBy", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "setChanged", "", "stillValid", "Lnet/minecraft/world/entity/player/Player;", "getInventoryTitle", "getMinecartType", "Lnet/minecraft/world/entity/vehicle/AbstractMinecart$Type;", "addAdditionalSaveData", "tag", "Lnet/minecraft/nbt/CompoundTag;", "readAdditionalSaveData", "interact", "Lnet/minecraft/world/InteractionResult;", "hand", "Lnet/minecraft/world/InteractionHand;", "remove", "reason", "Lnet/minecraft/world/entity/Entity$RemovalReason;", "onInitialOpen", "destroy", "damage", "Lnet/minecraft/world/damagesource/DamageSource;", "Companion", "expandedstorage-neoforge-1.21.1"})
public final class ChestMinecart
extends AbstractMinecart
implements ExposedInventory,
OpenableInventoryProvider<BaseContext>,
OpenableInventory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Item dropItem;
    @NotNull
    private final NonNullList<ItemStack> items;
    private final BlockState renderState;
    private final Component title;
    private final Item chestItem;

    public ChestMinecart(@NotNull EntityType<?> entityType, @NotNull Level level, @NotNull Item dropItem, @NotNull ChestBlock block) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)dropItem, (String)"dropItem");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        super(entityType, level);
        this.dropItem = dropItem;
        NonNullList nonNullList = NonNullList.withSize((int)block.getSlotCount(), (Object)ItemStack.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"withSize(...)");
        this.items = nonNullList;
        this.renderState = block.defaultBlockState();
        this.title = this.dropItem.getDescription();
        this.chestItem = block.asItem();
    }

    @Override
    @NotNull
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public final Component getTitle() {
        return this.title;
    }

    @NotNull
    protected Item getDropItem() {
        return this.dropItem;
    }

    @NotNull
    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)this.dropItem);
    }

    @NotNull
    public BlockState getDisplayBlockState() {
        BlockState blockState = this.renderState;
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"renderState");
        return blockState;
    }

    public int getDefaultDisplayOffset() {
        return 8;
    }

    @Override
    @NotNull
    public WorldlyContainer getInventory() {
        return this;
    }

    @Override
    @NotNull
    public OpenableInventory getOpenableInventory(@NotNull BaseContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this;
    }

    @Override
    public boolean canBeUsedBy(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.stillValid((Player)player);
    }

    public void setChanged() {
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return player.canInteractWithEntity((Entity)this, 4.0);
    }

    @Override
    @NotNull
    public Component getInventoryTitle() {
        Component component = this.getCustomName();
        if (component == null) {
            Component component2 = this.title;
            component = component2;
            Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"title");
        }
        return component;
    }

    @NotNull
    public AbstractMinecart.Type getMinecartType() {
        return AbstractMinecart.Type.CHEST;
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        super.addAdditionalSaveData(tag);
        RegistryAccess registryAccess = this.level().registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        this.saveInventoryToTag(tag, (HolderLookup.Provider)registryAccess);
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        super.readAdditionalSaveData(tag);
        RegistryAccess registryAccess = this.level().registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        this.loadInventoryFromTag(tag, (HolderLookup.Provider)registryAccess);
    }

    @NotNull
    public InteractionResult interact(@NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Level level = this.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        if (_UtilsKt.isServerSide(level)) {
            InventoryOpeningApi.openEntityInventory((ServerPlayer)player, this);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public void remove(@NotNull Entity.RemovalReason reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Level level = this.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        if (_UtilsKt.isServerSide(level) && reason.shouldDestroy()) {
            Containers.dropContents((Level)this.level(), (Entity)((Entity)this), (Container)((Container)this));
        }
        super.remove(reason);
    }

    @Override
    public void onInitialOpen(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PiglinAi.angerNearbyPiglins((Player)((Player)player), (boolean)true);
    }

    protected void destroy(@NotNull DamageSource damage) {
        Intrinsics.checkNotNullParameter((Object)damage, (String)"damage");
        this.kill();
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            ItemStack stack;
            Entity breaker = damage.getDirectEntity();
            if (breaker != null && breaker.isShiftKeyDown()) {
                this.spawnAtLocation((ItemLike)Items.MINECART);
                v0 = new ItemStack((ItemLike)this.chestItem);
            } else {
                v0 = stack = new ItemStack((ItemLike)this.dropItem);
            }
            if (this.hasCustomName()) {
                stack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
            }
            this.spawnAtLocation(stack);
            if (breaker != null && breaker.getType() == EntityType.PLAYER) {
                PiglinAi.angerNearbyPiglins((Player)((Player)breaker), (boolean)true);
            }
        }
    }

    @Override
    @NotNull
    public int[] getSlots() {
        return ExposedInventory.DefaultImpls.getSlots(this);
    }

    @Override
    public void loadInventoryFromTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        ExposedInventory.DefaultImpls.loadInventoryFromTag(this, tag, registries);
    }

    @Override
    public void saveInventoryToTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        ExposedInventory.DefaultImpls.saveInventoryToTag(this, tag, registries);
    }

    @Override
    public int replaceInventory(@NotNull NonNullList<ItemStack> replacement) {
        return ExposedInventory.DefaultImpls.replaceInventory(this, replacement);
    }

    @Override
    @NotNull
    public int[] getSlotsForFace(@NotNull Direction face) {
        return ExposedInventory.DefaultImpls.getSlotsForFace(this, face);
    }

    @Override
    public boolean canPlaceItemThroughFace(int slot, @NotNull ItemStack stack, @Nullable Direction face) {
        return ExposedInventory.DefaultImpls.canPlaceItemThroughFace(this, slot, stack, face);
    }

    @Override
    public boolean canTakeItemThroughFace(int slot, @NotNull ItemStack stack, @NotNull Direction face) {
        return ExposedInventory.DefaultImpls.canTakeItemThroughFace(this, slot, stack, face);
    }

    @Override
    public int getContainerSize() {
        return ExposedInventory.DefaultImpls.getContainerSize(this);
    }

    @Override
    public boolean isEmpty() {
        return ExposedInventory.DefaultImpls.isEmpty(this);
    }

    @Override
    @NotNull
    public ItemStack getItem(int slot) {
        return ExposedInventory.DefaultImpls.getItem(this, slot);
    }

    @Override
    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        return ExposedInventory.DefaultImpls.removeItem(this, slot, amount);
    }

    @Override
    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        return ExposedInventory.DefaultImpls.removeItemNoUpdate(this, slot);
    }

    @Override
    public void setItem(int slot, @NotNull ItemStack stack) {
        ExposedInventory.DefaultImpls.setItem(this, slot, stack);
    }

    @Override
    public void clearContent() {
        ExposedInventory.DefaultImpls.clearContent(this);
    }

    @JvmStatic
    @NotNull
    public static final ChestMinecart createMinecart(@NotNull Level level, @NotNull Vec3 pos, @NotNull ResourceLocation cartItemId) {
        return Companion.createMinecart(level, pos, cartItemId);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Ldev/compasses/expandedstorage/entity/ChestMinecart$Companion;", "", "<init>", "()V", "createMinecart", "Ldev/compasses/expandedstorage/entity/ChestMinecart;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/world/phys/Vec3;", "cartItemId", "Lnet/minecraft/resources/ResourceLocation;", "expandedstorage-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ChestMinecart createMinecart(@NotNull Level level, @NotNull Vec3 pos, @NotNull ResourceLocation cartItemId) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)cartItemId, (String)"cartItemId");
            ChestMinecart chestMinecart = level.registryAccess().registry(Registries.ENTITY_TYPE).map(arg_0 -> Companion.createMinecart$lambda$1(arg_0 -> Companion.createMinecart$lambda$0(cartItemId, level, pos, arg_0), arg_0)).orElseThrow();
            Intrinsics.checkNotNullExpressionValue((Object)chestMinecart, (String)"orElseThrow(...)");
            return chestMinecart;
        }

        private static final ChestMinecart createMinecart$lambda$0(ResourceLocation $cartItemId, Level $level, Vec3 $pos, Registry it) {
            Object object = it.get($cartItemId);
            Intrinsics.checkNotNull((Object)object);
            Entity entity = ((EntityType)object).create($level);
            Intrinsics.checkNotNull((Object)entity);
            Entity cart = entity;
            cart.setPos($pos);
            return (ChestMinecart)cart;
        }

        private static final ChestMinecart createMinecart$lambda$1(Function1 $tmp0, Object p0) {
            return (ChestMinecart)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

