/*
 * Decompiled with CFR 0.152.
 */
package dev.compasses.expandedstorage.block.entity;

import compasses.expandedstorage.impl.block.OpenableBlock;
import compasses.expandedstorage.impl.block.strategies.ItemAccess;
import compasses.expandedstorage.impl.block.strategies.Lockable;
import compasses.expandedstorage.impl.inventory.OpenableInventory;
import dev.compasses.expandedstorage.inventory.ExposedInventory;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Nameable;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004BI\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u0000\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\f\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0014J\u0018\u00101\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0014J\u000e\u00102\u001a\u00020,2\u0006\u00103\u001a\u00020\u001dJ\n\u00104\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u00105\u001a\u00020\u001dH\u0016J\b\u00106\u001a\u00020\u001dH\u0016J\u0010\u00107\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00108\u001a\u00020(2\u0006\u0010)\u001a\u000209H\u0016J\b\u0010:\u001a\u00020;H\u0016J\u0006\u0010<\u001a\u00020(R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\r8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b \u0010!R\u0011\u0010$\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006="}, d2={"Ldev/compasses/expandedstorage/block/entity/BaseBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Ldev/compasses/expandedstorage/inventory/ExposedInventory;", "Lcompasses/expandedstorage/impl/inventory/OpenableInventory;", "Lnet/minecraft/world/Nameable;", "type", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "itemAccessMaker", "Ljava/util/function/Function;", "Lcompasses/expandedstorage/impl/block/strategies/ItemAccess;", "lockableMaker", "Ljava/util/function/Supplier;", "Lcompasses/expandedstorage/impl/block/strategies/Lockable;", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Ljava/util/function/Function;Ljava/util/function/Supplier;)V", "items", "Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/item/ItemStack;", "getItems", "()Lnet/minecraft/core/NonNullList;", "blockId", "Lnet/minecraft/resources/ResourceLocation;", "getBlockId", "()Lnet/minecraft/resources/ResourceLocation;", "defaultName", "Lnet/minecraft/network/chat/Component;", "customName", "itemAccess", "getItemAccess", "()Lcompasses/expandedstorage/impl/block/strategies/ItemAccess;", "itemAccess$delegate", "Lkotlin/Lazy;", "lockable", "getLockable", "()Lcompasses/expandedstorage/impl/block/strategies/Lockable;", "canBeUsedBy", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "loadAdditional", "", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "saveAdditional", "setCustomName", "name", "getCustomName", "getName", "getInventoryTitle", "getUpdateTag", "stillValid", "Lnet/minecraft/world/entity/player/Player;", "getInventory", "Lnet/minecraft/world/WorldlyContainer;", "isDinnerbone", "expandedstorage-neoforge-1.21.1"})
public abstract class BaseBlockEntity
extends BlockEntity
implements ExposedInventory,
OpenableInventory,
Nameable {
    @NotNull
    private final NonNullList<ItemStack> items;
    @NotNull
    private final ResourceLocation blockId;
    @NotNull
    private final Component defaultName;
    @Nullable
    private Component customName;
    @NotNull
    private final Lazy itemAccess$delegate;
    @NotNull
    private final Lockable lockable;

    public BaseBlockEntity(@NotNull BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Function<BaseBlockEntity, ItemAccess<?>> itemAccessMaker, @NotNull Supplier<Lockable> lockableMaker) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(itemAccessMaker, (String)"itemAccessMaker");
        Intrinsics.checkNotNullParameter(lockableMaker, (String)"lockableMaker");
        super(type, pos, state);
        this.itemAccess$delegate = LazyKt.lazy(() -> BaseBlockEntity.itemAccess_delegate$lambda$0(itemAccessMaker, this));
        Lockable lockable = lockableMaker.get();
        Intrinsics.checkNotNullExpressionValue((Object)lockable, (String)"get(...)");
        this.lockable = lockable;
        Block block = state.getBlock();
        Intrinsics.checkNotNull((Object)block, (String)"null cannot be cast to non-null type compasses.expandedstorage.impl.block.OpenableBlock");
        OpenableBlock block2 = (OpenableBlock)block;
        this.items = NonNullList.withSize((int)block2.getSlotCount(), (Object)ItemStack.EMPTY);
        this.blockId = block2.getBlockId();
        this.defaultName = block2.getInventoryTitle();
    }

    @Override
    @NotNull
    public final NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @NotNull
    public final ResourceLocation getBlockId() {
        return this.blockId;
    }

    @NotNull
    public ItemAccess<?> getItemAccess() {
        Lazy lazy = this.itemAccess$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (ItemAccess)object;
    }

    @NotNull
    public final Lockable getLockable() {
        return this.lockable;
    }

    @Override
    public boolean canBeUsedBy(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.stillValid((Player)player) && this.lockable.canPlayerOpenLock(player);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        this.lockable.readLock(tag, registries);
        if (tag.contains("CustomName", 8)) {
            this.customName = (Component)Component.Serializer.fromJson((String)tag.getString("CustomName"), (HolderLookup.Provider)registries);
        }
        this.loadInventoryFromTag(tag, registries);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        this.lockable.writeLock(tag, registries);
        Component component = this.customName;
        if (component != null) {
            Component it = component;
            boolean bl = false;
            tag.putString("CustomName", Component.Serializer.toJson((Component)it, (HolderLookup.Provider)registries));
        }
        this.saveInventoryToTag(tag, registries);
    }

    public final void setCustomName(@NotNull Component name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.customName = name;
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    @NotNull
    public Component getName() {
        Component component = this.customName;
        if (component == null) {
            component = this.defaultName;
        }
        return component;
    }

    @Override
    @NotNull
    public Component getInventoryTitle() {
        return this.getName();
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider registries) {
        CompoundTag compoundTag;
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        CompoundTag tag = compoundTag = super.getUpdateTag(registries);
        boolean bl = false;
        Component component = this.customName;
        if (component != null) {
            Component it = component;
            boolean bl2 = false;
            tag.putString("CustomName", Component.Serializer.toJson((Component)it, (HolderLookup.Provider)registries));
        }
        CompoundTag compoundTag2 = compoundTag;
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag2, (String)"also(...)");
        return compoundTag2;
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    @Override
    @NotNull
    public WorldlyContainer getInventory() {
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isDinnerbone() {
        Component component = this.customName;
        if (Intrinsics.areEqual((Object)(component != null ? component.getString() : null), (Object)"Dinnerbone")) return true;
        Component component2 = this.customName;
        if (!Intrinsics.areEqual((Object)(component2 != null ? component2.getString() : null), (Object)"Grumm")) return false;
        return true;
    }

    @Override
    @NotNull
    public int[] getSlots() {
        return ExposedInventory.DefaultImpls.getSlots(this);
    }

    @Override
    public void loadInventoryFromTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        ExposedInventory.DefaultImpls.loadInventoryFromTag(this, tag, registries);
    }

    @Override
    public void saveInventoryToTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        ExposedInventory.DefaultImpls.saveInventoryToTag(this, tag, registries);
    }

    @Override
    public int replaceInventory(@NotNull NonNullList<ItemStack> replacement) {
        return ExposedInventory.DefaultImpls.replaceInventory(this, replacement);
    }

    @Override
    @NotNull
    public int[] getSlotsForFace(@NotNull Direction face) {
        return ExposedInventory.DefaultImpls.getSlotsForFace(this, face);
    }

    @Override
    public boolean canPlaceItemThroughFace(int slot, @NotNull ItemStack stack, @Nullable Direction face) {
        return ExposedInventory.DefaultImpls.canPlaceItemThroughFace(this, slot, stack, face);
    }

    @Override
    public boolean canTakeItemThroughFace(int slot, @NotNull ItemStack stack, @NotNull Direction face) {
        return ExposedInventory.DefaultImpls.canTakeItemThroughFace(this, slot, stack, face);
    }

    @Override
    public int getContainerSize() {
        return ExposedInventory.DefaultImpls.getContainerSize(this);
    }

    @Override
    public boolean isEmpty() {
        return ExposedInventory.DefaultImpls.isEmpty(this);
    }

    @Override
    @NotNull
    public ItemStack getItem(int slot) {
        return ExposedInventory.DefaultImpls.getItem(this, slot);
    }

    @Override
    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        return ExposedInventory.DefaultImpls.removeItem(this, slot, amount);
    }

    @Override
    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        return ExposedInventory.DefaultImpls.removeItemNoUpdate(this, slot);
    }

    @Override
    public void setItem(int slot, @NotNull ItemStack stack) {
        ExposedInventory.DefaultImpls.setItem(this, slot, stack);
    }

    @Override
    public void clearContent() {
        ExposedInventory.DefaultImpls.clearContent(this);
    }

    private static final ItemAccess itemAccess_delegate$lambda$0(Function $itemAccessMaker, BaseBlockEntity this$0) {
        return (ItemAccess)$itemAccessMaker.apply(this$0);
    }
}

