/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.recipe.misc;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import compasses.expandedstorage.impl.item.StorageConversionKit;
import compasses.expandedstorage.impl.misc.Utils;
import compasses.expandedstorage.impl.recipe.misc.JsonHelper;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public abstract sealed class RecipeTool {
    private final ResourceLocation toolId;

    private RecipeTool(ResourceLocation toolId) {
        this.toolId = toolId;
    }

    public boolean isMatchFor(ItemStack tool) {
        return tool.getItem().builtInRegistryHolder().is(this.toolId);
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.writeResourceLocation(this.toolId);
    }

    public JsonObject toJson() {
        JsonObject tool = new JsonObject();
        tool.addProperty("id", this.toolId.toString());
        return tool;
    }

    public static RecipeTool fromJsonObject(JsonObject object) {
        ResourceLocation toolId = JsonHelper.getJsonResourceLocation(object, "id");
        if (toolId.toString().equals("expandedstorage:storage_mutator")) {
            if (object.has("name")) {
                JsonElement name = object.get("name");
                if (name.isJsonPrimitive() && name.getAsJsonPrimitive().isString()) {
                    return new MutatorTool(name.getAsString());
                }
                throw new JsonSyntaxException("Tool's name entry must be a string");
            }
            return new MutatorTool(null);
        }
        if (BuiltInRegistries.ITEM.get(toolId) instanceof StorageConversionKit) {
            return new UpgradeTool(toolId);
        }
        throw new IllegalArgumentException("Tool id supplied is not a conversion kit or the storage mutator.");
    }

    public static RecipeTool fromNetworkBuffer(FriendlyByteBuf buffer) {
        ResourceLocation toolId = buffer.readResourceLocation();
        if (toolId.toString().equals("expandedstorage:storage_mutator")) {
            String name = (String)buffer.readNullable(FriendlyByteBuf::readUtf);
            return new MutatorTool(name);
        }
        if (BuiltInRegistries.ITEM.get(toolId) instanceof StorageConversionKit) {
            return new UpgradeTool(toolId);
        }
        throw new IllegalArgumentException("Invalid tool id sent by the server.");
    }

    public static final class MutatorTool
    extends RecipeTool {
        private final String requiredName;

        public MutatorTool(String requiredName) {
            super(Utils.id("storage_mutator"));
            this.requiredName = requiredName;
        }

        @Override
        public boolean isMatchFor(ItemStack tool) {
            boolean isNameMatch = true;
            if (this.requiredName != null) {
                isNameMatch = tool.getHoverName().getString().equalsIgnoreCase(this.requiredName);
            }
            return isNameMatch && super.isMatchFor(tool);
        }

        @Override
        public void writeToBuffer(FriendlyByteBuf buffer) {
            super.writeToBuffer(buffer);
            buffer.writeNullable((Object)this.requiredName, FriendlyByteBuf::writeUtf);
        }

        @Override
        public JsonObject toJson() {
            JsonObject tool = super.toJson();
            if (this.requiredName != null) {
                tool.addProperty("name", this.requiredName);
            }
            return tool;
        }

        public String getRequiredName() {
            return this.requiredName;
        }
    }

    public static final class UpgradeTool
    extends RecipeTool {
        public UpgradeTool(ResourceLocation toolId) {
            super(toolId);
        }

        public UpgradeTool(Item item) {
            super(item.builtInRegistryHolder().key().location());
        }
    }
}

