/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.recipe.conditions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import compasses.expandedstorage.impl.misc.Utils;
import compasses.expandedstorage.impl.recipe.conditions.AndCondition;
import compasses.expandedstorage.impl.recipe.conditions.HasPropertyCondition;
import compasses.expandedstorage.impl.recipe.conditions.IsInTagCondition;
import compasses.expandedstorage.impl.recipe.conditions.IsInstanceOfCondition;
import compasses.expandedstorage.impl.recipe.conditions.IsRegistryObject;
import compasses.expandedstorage.impl.recipe.conditions.OrCondition;
import compasses.expandedstorage.impl.recipe.misc.JsonHelper;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public interface RecipeCondition {
    public static final Map<ResourceLocation, Function<FriendlyByteBuf, RecipeCondition>> RECIPE_DESERIALIZERS = Map.of(AndCondition.NETWORK_ID, AndCondition::readFromBuffer, HasPropertyCondition.NETWORK_ID, HasPropertyCondition::readFromBuffer, IsInstanceOfCondition.NETWORK_ID, IsInstanceOfCondition::readFromBuffer, IsInTagCondition.NETWORK_ID, IsInTagCondition::readFromBuffer, IsRegistryObject.NETWORK_ID, IsRegistryObject::readFromBuffer, OrCondition.NETWORK_ID, OrCondition::readFromBuffer);
    public static final ResourceLocation IS_WOODEN_CHEST_ID = Utils.id("is_wooden_chest");
    public static final ResourceLocation IS_WOODEN_BARREL_ID = Utils.id("is_wooden_barrel");
    public static final IsInstanceOfCondition IS_WOODEN_CHEST = new IsInstanceOfCondition(ChestBlock.class);
    public static final IsInstanceOfCondition IS_WOODEN_BARREL = new IsInstanceOfCondition(BarrelBlock.class);

    private static <T> RecipeCondition tryReadGenericCondition(JsonElement condition, Registry<T> registry) {
        if (condition.isJsonObject()) {
            JsonObject object = condition.getAsJsonObject();
            if (object.has("tag")) {
                TagKey tag = TagKey.create((ResourceKey)registry.key(), (ResourceLocation)JsonHelper.getJsonResourceLocation(object, "tag"));
                return new IsInTagCondition(tag);
            }
            if (object.has("id")) {
                return new IsRegistryObject(registry, JsonHelper.getJsonResourceLocation(object, "id"));
            }
            return null;
        }
        if (condition.isJsonArray()) {
            JsonArray conditions = condition.getAsJsonArray();
            RecipeCondition[] recipeConditions = new RecipeCondition[conditions.size()];
            Function<JsonElement, RecipeCondition> function = registry == BuiltInRegistries.BLOCK ? RecipeCondition::readBlockCondition : RecipeCondition::readEntityCondition;
            for (int i = 0; i < conditions.size(); ++i) {
                recipeConditions[i] = function.apply(conditions.get(i));
            }
            return new OrCondition(recipeConditions);
        }
        throw new JsonSyntaxException("condition must be an Object or an Array.");
    }

    public static RecipeCondition readBlockCondition(JsonElement condition) {
        JsonObject recipeCondition;
        RecipeCondition generic = RecipeCondition.tryReadGenericCondition(condition, BuiltInRegistries.BLOCK);
        if (generic != null) {
            if (generic instanceof IsInTagCondition) {
                JsonObject objCondition = (JsonObject)condition;
                if (objCondition.has("state")) {
                    throw new IllegalStateException("Cannot combine in tag and has property checks.");
                }
            } else if (generic instanceof IsRegistryObject) {
                IsRegistryObject isRegistryObject = (IsRegistryObject)generic;
                JsonObject objCondition = (JsonObject)condition;
                if (objCondition.has("state")) {
                    Block block = (Block)isRegistryObject.getValue();
                    Map<String, Property> propertyLookup = block.defaultBlockState().getProperties().stream().map(it -> Map.entry(it.getName(), it)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    boolean optional = objCondition.has("optional") && JsonHelper.getJsonBoolean(objCondition, "optional");
                    JsonObject properties = JsonHelper.getJsonObject(objCondition, "state");
                    Map.Entry[] stateProperties = new Map.Entry[properties.size()];
                    int index = 0;
                    for (Map.Entry propertyEntry : properties.entrySet()) {
                        String propertyValue;
                        if (!propertyLookup.containsKey(propertyEntry.getKey())) {
                            throw new IllegalArgumentException("Block does not contain property with name: " + (String)propertyEntry.getKey());
                        }
                        Property property = propertyLookup.get(propertyEntry.getKey());
                        Optional value = property.getValue(propertyValue = JsonHelper.toString(property.getName(), (JsonElement)propertyEntry.getValue()));
                        if (value.isEmpty()) {
                            throw new IllegalStateException("Property " + property.getName() + " doesn't contain value " + propertyValue);
                        }
                        stateProperties[index] = Map.entry(property, value.get());
                        ++index;
                    }
                    return new AndCondition(generic, new HasPropertyCondition(block.builtInRegistryHolder().key().location(), Map.ofEntries(stateProperties), optional));
                }
            }
            return generic;
        }
        if (condition.isJsonObject() && (recipeCondition = condition.getAsJsonObject()).has("condition")) {
            ResourceLocation conditionId = JsonHelper.getJsonResourceLocation(recipeCondition, "condition");
            if (IS_WOODEN_CHEST_ID.equals((Object)conditionId)) {
                return IS_WOODEN_CHEST;
            }
            if (IS_WOODEN_BARREL_ID.equals((Object)conditionId)) {
                return IS_WOODEN_BARREL;
            }
            throw new IllegalArgumentException("condition with id " + String.valueOf(conditionId) + " doesn't exist.");
        }
        throw new JsonSyntaxException("Unknown recipe condition");
    }

    public static RecipeCondition readEntityCondition(JsonElement condition) {
        RecipeCondition generic = RecipeCondition.tryReadGenericCondition(condition, BuiltInRegistries.ENTITY_TYPE);
        if (generic != null) {
            return generic;
        }
        throw new JsonSyntaxException("Unknown recipe condition");
    }

    public static Object unwrap(Object subject) {
        if (subject instanceof BlockState) {
            BlockState state = (BlockState)subject;
            return state.getBlock();
        }
        if (subject instanceof Entity) {
            Entity entity = (Entity)subject;
            return entity.getType();
        }
        return subject;
    }

    public boolean isExactMatch();

    public boolean test(Object var1);

    public ResourceLocation getNetworkId();

    public void writeToBuffer(FriendlyByteBuf var1);

    public static RecipeCondition readFromNetworkBuffer(FriendlyByteBuf buffer) {
        ResourceLocation id = buffer.readResourceLocation();
        if (RECIPE_DESERIALIZERS.containsKey(id)) {
            return RECIPE_DESERIALIZERS.get(id).apply(buffer);
        }
        throw new IllegalStateException("Cannot find recipe condition with id: \"" + String.valueOf(id) + "\"");
    }

    @Nullable
    public JsonElement toJson(@Nullable JsonObject var1);
}

