/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.recipe.conditions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import compasses.expandedstorage.impl.misc.Utils;
import compasses.expandedstorage.impl.recipe.conditions.RecipeCondition;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.Nullable;

public class IsInTagCondition
implements RecipeCondition {
    public static final ResourceLocation NETWORK_ID = Utils.id("in_tag");
    private final TagKey<?> tagKey;
    private Set<Object> values;

    public IsInTagCondition(TagKey<?> tagKey) {
        this.tagKey = tagKey;
    }

    @Override
    public boolean isExactMatch() {
        return false;
    }

    @Override
    public boolean test(Object subject) {
        if (this.values == null) {
            this.values = ((HolderSet.Named)((Registry)BuiltInRegistries.REGISTRY.get(this.tagKey.registry().location())).getTag(this.tagKey).orElseThrow()).stream().map(Holder::value).collect(Collectors.toUnmodifiableSet());
        }
        return this.values.contains(RecipeCondition.unwrap(subject));
    }

    @Override
    public ResourceLocation getNetworkId() {
        return NETWORK_ID;
    }

    @Override
    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.writeResourceLocation(this.tagKey.registry().location());
        buffer.writeResourceLocation(this.tagKey.location());
    }

    public static IsInTagCondition readFromBuffer(FriendlyByteBuf buffer) {
        ResourceLocation registryId = buffer.readResourceLocation();
        ResourceLocation tag = buffer.readResourceLocation();
        Registry registry = (Registry)BuiltInRegistries.REGISTRY.get(registryId);
        if (registry == null) {
            throw new NullPointerException("Unknown registry: " + String.valueOf(registryId));
        }
        return new IsInTagCondition(TagKey.create((ResourceKey)registry.key(), (ResourceLocation)tag));
    }

    @Override
    @Nullable
    public JsonElement toJson(@Nullable JsonObject object) {
        if (object != null) {
            this.writeToJsonObject(object);
            return null;
        }
        JsonObject jsonObject = new JsonObject();
        this.writeToJsonObject(jsonObject);
        return jsonObject;
    }

    private void writeToJsonObject(JsonObject object) {
        object.addProperty("tag", this.tagKey.location().toString());
    }
}

