/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import compasses.expandedstorage.api.EsChestType;
import compasses.expandedstorage.api.ExpandedStorageAccessors;
import compasses.expandedstorage.impl.block.AbstractChestBlock;
import compasses.expandedstorage.impl.item.StorageConversionKit;
import compasses.expandedstorage.impl.item.ToolUsageResult;
import compasses.expandedstorage.impl.misc.ItemAccessor;
import compasses.expandedstorage.impl.recipe.ConversionRecipe;
import compasses.expandedstorage.impl.recipe.conditions.RecipeCondition;
import compasses.expandedstorage.impl.recipe.misc.PartialBlockState;
import compasses.expandedstorage.impl.recipe.misc.RecipeTool;
import dev.compasses.expandedstorage.block.entity.BaseBlockEntity;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockConversionRecipe<O extends Block>
extends ConversionRecipe<BlockState> {
    private final PartialBlockState<O> output;

    public BlockConversionRecipe(RecipeTool recipeTool, PartialBlockState<O> output, RecipeCondition input) {
        super(recipeTool, input);
        this.output = output;
    }

    public final ToolUsageResult process(Level level, Player player, ItemStack tool, BlockState clickedState, BlockPos clickedPos) {
        ArrayList<BlockPos> convertPositions = new ArrayList<BlockPos>();
        convertPositions.add(clickedPos);
        if (clickedState.hasProperty((Property)BlockStateProperties.CHEST_TYPE)) {
            ChestType type = (ChestType)clickedState.getValue((Property)BlockStateProperties.CHEST_TYPE);
            if (type != ChestType.SINGLE) {
                convertPositions.add(clickedPos.relative(ChestBlock.getConnectedDirection((BlockState)clickedState)));
            }
        } else if (clickedState.hasProperty(AbstractChestBlock.CURSED_CHEST_TYPE) && clickedState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            ExpandedStorageAccessors.getAttachedChestDirection(clickedState).ifPresent(direction -> convertPositions.add(clickedPos.relative(direction)));
        }
        if (tool.getCount() < convertPositions.size() && !player.isCreative()) {
            return StorageConversionKit.NOT_ENOUGH_UPGRADES;
        }
        HashMap<BlockPos, InputState> originalStates = new HashMap<BlockPos, InputState>();
        for (BlockPos position : convertPositions) {
            BlockEntity entity = level.getBlockEntity(position);
            if (!(entity instanceof BaseBlockEntity) && !(entity instanceof RandomizableContainerBlockEntity)) {
                return ToolUsageResult.fail();
            }
            originalStates.put(position, new InputState(level.getBlockState(position), entity));
        }
        int toolsUsed = 0;
        for (BlockPos position : convertPositions) {
            NonNullList<ItemStack> originalItems;
            BaseBlockEntity entity;
            InputState input = (InputState)originalStates.get(position);
            BlockState originalState = input.state();
            BlockState newState = this.output.getBlock().withPropertiesOf(originalState);
            if (originalState.hasProperty((Property)BlockStateProperties.CHEST_TYPE) && newState.hasProperty(AbstractChestBlock.CURSED_CHEST_TYPE)) {
                newState = (BlockState)newState.setValue(AbstractChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)EsChestType.from((ChestType)originalState.getValue((Property)BlockStateProperties.CHEST_TYPE))));
            }
            if ((newState = this.output.transform(newState)) == originalState) continue;
            Component customName = null;
            CompoundTag tagForLock = input.entity().saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
            BlockEntity blockEntity = input.entity();
            if (blockEntity instanceof BaseBlockEntity) {
                entity = (BaseBlockEntity)blockEntity;
                originalItems = entity.getItems();
                if (entity.hasCustomName()) {
                    customName = entity.getName();
                }
            } else {
                blockEntity = input.entity();
                if (blockEntity instanceof RandomizableContainerBlockEntity) {
                    RandomizableContainerBlockEntity entity2 = (RandomizableContainerBlockEntity)blockEntity;
                    originalItems = ((ItemAccessor)entity2).expandedstorage$getItems();
                    customName = entity2.getCustomName();
                } else {
                    throw new IllegalStateException();
                }
            }
            level.removeBlockEntity(position);
            if (level.setBlockAndUpdate(position, newState)) {
                blockEntity = level.getBlockEntity(position);
                if (blockEntity instanceof BaseBlockEntity) {
                    int i;
                    entity = (BaseBlockEntity)blockEntity;
                    NonNullList<ItemStack> newInventory = entity.getItems();
                    int commonSize = Math.min(originalItems.size(), newInventory.size());
                    for (i = 0; i < commonSize; ++i) {
                        newInventory.set(i, (ItemStack)originalItems.get(i));
                    }
                    if (newInventory.size() < originalItems.size()) {
                        for (i = newInventory.size(); i < originalItems.size(); ++i) {
                            Containers.dropItemStack((Level)level, (double)position.getX(), (double)position.getY(), (double)position.getZ(), (ItemStack)((ItemStack)originalItems.get(i)));
                        }
                    }
                    if (customName != null) {
                        entity.setCustomName(customName);
                    }
                    entity.getLockable().readLock(tagForLock, (HolderLookup.Provider)level.registryAccess());
                }
                ++toolsUsed;
                continue;
            }
            level.setBlockEntity(input.entity());
        }
        if (this.recipeTool instanceof RecipeTool.UpgradeTool) {
            tool.setCount(tool.getCount() - toolsUsed);
        }
        return toolsUsed > 0 ? ToolUsageResult.slowSuccess() : ToolUsageResult.fail();
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        this.recipeTool.writeToBuffer(buffer);
        this.output.writeToBuffer(buffer);
        buffer.writeResourceLocation(this.input.getNetworkId());
        this.input.writeToBuffer(buffer);
    }

    public static BlockConversionRecipe<?> readFromBuffer(FriendlyByteBuf buffer) {
        RecipeTool recipeTool = RecipeTool.fromNetworkBuffer(buffer);
        PartialBlockState<?> output = PartialBlockState.readFromBuffer(buffer);
        RecipeCondition inputs = RecipeCondition.readFromNetworkBuffer(buffer);
        return new BlockConversionRecipe(recipeTool, output, inputs);
    }

    @Override
    public JsonElement toJson() {
        JsonObject recipe = new JsonObject();
        recipe.addProperty("type", "expandedstorage:block_conversion");
        recipe.add("tool", (JsonElement)this.recipeTool.toJson());
        recipe.add("result", (JsonElement)this.output.toJson());
        recipe.add("inputs", this.input.toJson(null));
        return recipe;
    }

    private record InputState(BlockState state, BlockEntity entity) {
    }
}

