/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.networking;

import compasses.expandedstorage.impl.misc.Utils;
import compasses.expandedstorage.impl.recipe.BlockConversionRecipe;
import compasses.expandedstorage.impl.recipe.EntityConversionRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import org.jetbrains.annotations.NotNull;

public record UpdateRecipesPacketPayload(List<BlockConversionRecipe<?>> blockRecipes, List<EntityConversionRecipe<?>> entityRecipes) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateRecipesPacketPayload> TYPE = new CustomPacketPayload.Type(Utils.id("update_conversion_recipes"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateRecipesPacketPayload> CODEC = StreamCodec.of(UpdateRecipesPacketPayload::encode, UpdateRecipesPacketPayload::decode);

    private static UpdateRecipesPacketPayload decode(RegistryFriendlyByteBuf buffer) {
        ArrayList blockRecipes = new ArrayList(buffer.readCollection(ArrayList::new, BlockConversionRecipe::readFromBuffer));
        ArrayList entityRecipes = new ArrayList(buffer.readCollection(ArrayList::new, EntityConversionRecipe::readFromBuffer));
        return new UpdateRecipesPacketPayload(blockRecipes, entityRecipes);
    }

    private static void encode(RegistryFriendlyByteBuf buffer, UpdateRecipesPacketPayload payload) {
        buffer.writeCollection(payload.blockRecipes, (b, recipe) -> recipe.writeToBuffer((FriendlyByteBuf)b));
        buffer.writeCollection(payload.entityRecipes, (b, recipe) -> recipe.writeToBuffer((FriendlyByteBuf)b));
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

