/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.mixin.common;

import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class SparrowItemIdFix {
    @Shadow
    @Final
    private static Logger LOGGER;

    @Inject(method={"parse(Lnet/minecraft/core/HolderLookup$Provider;Lnet/minecraft/nbt/Tag;)Ljava/util/Optional;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void expandedstorage$sparrowItemIdFix(HolderLookup.Provider provider, Tag tag, CallbackInfoReturnable<Optional<ItemStack>> cir) {
        String id;
        CompoundTag compoundTag;
        if (tag instanceof CompoundTag && (compoundTag = (CompoundTag)tag).contains("id", 8) && (id = compoundTag.getString("id")).startsWith("expandedstorage:") && id.endsWith("_with_sparrow")) {
            CompoundTag fixedTag = new CompoundTag();
            fixedTag.putString("id", id.substring(0, id.length() - 13));
            CompoundTag itemTag = new CompoundTag();
            CompoundTag properties = new CompoundTag();
            properties.putString("sparrow", "true");
            itemTag.put("BlockStateTag", (Tag)properties);
            fixedTag.put("tag", (Tag)itemTag);
            compoundTag.merge(fixedTag);
            try {
                cir.setReturnValue((Object)ItemStack.parse((HolderLookup.Provider)provider, (Tag)compoundTag));
            }
            catch (RuntimeException e) {
                LOGGER.debug("Expanded Storage: Tried to load invalid item: {}", (Object)compoundTag, (Object)e);
                cir.setReturnValue(Optional.empty());
            }
        }
    }
}

