/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.misc;

import compasses.expandedstorage.impl.inventory.handler.AbstractHandler;
import compasses.expandedstorage.impl.misc.CommonPlatformHelper;
import compasses.expandedstorage.impl.networking.UpdateRecipesPacketPayload;
import compasses.expandedstorage.impl.recipe.BlockConversionRecipe;
import compasses.expandedstorage.impl.recipe.EntityConversionRecipe;
import compasses.expandedstorage.impl.registration.ModBlocks;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.network.IContainerFactory;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class ForgeCommonHelper
implements CommonPlatformHelper {
    private final MenuType<AbstractHandler> menuType = new MenuType((MenuType.MenuSupplier)((IContainerFactory)(syncId, playerInventory, buffer) -> AbstractHandler.createClientMenu(syncId, playerInventory, buffer.readInt(), (ResourceLocation)buffer.readNullable(FriendlyByteBuf::readResourceLocation))), FeatureFlags.VANILLA_SET);

    @Override
    public MenuType<AbstractHandler> getScreenHandlerType() {
        return this.menuType;
    }

    @Override
    public void openScreenHandler(ServerPlayer player, Container inventory, Component title, ResourceLocation forcedScreenType) {
        player.openMenu((MenuProvider)new SimpleMenuProvider((syncId, playerInventory, _player) -> new AbstractHandler(syncId, inventory, playerInventory, forcedScreenType), title), buffer -> {
            buffer.writeInt(inventory.getContainerSize());
            buffer.writeNullable((Object)forcedScreenType, FriendlyByteBuf::writeResourceLocation);
        });
    }

    @Override
    public void sendConversionRecipesToClient(@Nullable ServerPlayer target, List<BlockConversionRecipe<?>> blockRecipes, List<EntityConversionRecipe<?>> entityRecipes) {
        if (target == null) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new UpdateRecipesPacketPayload(blockRecipes, entityRecipes), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            PacketDistributor.sendToPlayer((ServerPlayer)target, (CustomPacketPayload)new UpdateRecipesPacketPayload(blockRecipes, entityRecipes), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public boolean canDestroyBamboo(ItemStack stack) {
        return stack.canPerformAction(ItemAbilities.SWORD_DIG);
    }

    @Override
    public boolean isWoodenChest(BlockState state) {
        return state.is((Block)ModBlocks.OLD_WOOD_CHEST) || state.is(Tags.Blocks.CHESTS_WOODEN);
    }

    @Override
    public void invalidateCapabilityCache(Level level, BlockPos pos) {
        level.invalidateCapabilities(pos);
    }
}

