/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.item;

import compasses.expandedstorage.impl.CommonMain;
import compasses.expandedstorage.impl.item.BlockMutatorBehaviour;
import compasses.expandedstorage.impl.item.EntityInteractableItem;
import compasses.expandedstorage.impl.item.MutationMode;
import compasses.expandedstorage.impl.item.MutatorData;
import compasses.expandedstorage.impl.item.ToolUsageResult;
import compasses.expandedstorage.impl.misc.ESDataComponents;
import compasses.expandedstorage.impl.misc.Utils;
import compasses.expandedstorage.impl.recipe.ConversionRecipeManager;
import compasses.expandedstorage.impl.recipe.EntityConversionRecipe;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public final class StorageMutator
extends Item
implements EntityInteractableItem {
    public StorageMutator(Item.Properties settings) {
        super(settings);
    }

    public static MutationMode getMode(ItemStack stack) {
        if (!stack.has(ESDataComponents.MUTATOR_DATA)) {
            stack.set(ESDataComponents.MUTATOR_DATA, (Object)new MutatorData(MutationMode.MERGE, Optional.empty()));
        }
        return ((MutatorData)stack.get(ESDataComponents.MUTATOR_DATA)).mode();
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        ItemStack stack = context.getItemInHand();
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos = context.getClickedPos());
        BlockMutatorBehaviour behaviour = CommonMain.getBlockMutatorBehaviour(state.getBlock(), StorageMutator.getMode(stack));
        if (behaviour != null) {
            ToolUsageResult returnValue = behaviour.attempt(context, level, state, pos, stack);
            if (returnValue.getResult().shouldSwing()) {
                context.getPlayer().getCooldowns().addCooldown((Item)this, returnValue.getDelay());
            }
            return returnValue.getResult();
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (player.isShiftKeyDown()) {
            ItemStack stack = player.getItemInHand(hand);
            MutationMode nextMode = StorageMutator.getMode(stack).next();
            stack.set(ESDataComponents.MUTATOR_DATA, (Object)new MutatorData(nextMode, Optional.empty()));
            if (!level.isClientSide()) {
                player.displayClientMessage((Component)Component.translatable((String)("tooltip.expandedstorage.storage_mutator.description_" + String.valueOf((Object)nextMode)), (Object[])new Object[]{Utils.ALT_USE}), true);
            }
            player.getCooldowns().addCooldown((Item)this, 5);
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
    }

    public void onCraftedBy(ItemStack stack, Level level, Player player) {
        super.onCraftedBy(stack, level, player);
        StorageMutator.getMode(stack);
    }

    @NotNull
    public ItemStack getDefaultInstance() {
        ItemStack stack = super.getDefaultInstance();
        StorageMutator.getMode(stack);
        return stack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        MutationMode mode = StorageMutator.getMode(stack);
        list.add((Component)Component.translatable((String)"tooltip.expandedstorage.storage_mutator.tool_mode", (Object[])new Object[]{Component.translatable((String)("tooltip.expandedstorage.storage_mutator." + String.valueOf((Object)mode)))}).withStyle(ChatFormatting.GRAY));
        list.add((Component)Component.translatable((String)("tooltip.expandedstorage.storage_mutator.description_" + String.valueOf((Object)mode)), (Object[])new Object[]{Utils.ALT_USE}).withStyle(ChatFormatting.GRAY));
    }

    @Override
    public InteractionResult es_interactEntity(Level level, Entity entity, Player player, InteractionHand hand, ItemStack stack) {
        EntityConversionRecipe<?> recipe;
        MutationMode mode = StorageMutator.getMode(stack);
        if (mode == MutationMode.SWAP_THEME && (recipe = ConversionRecipeManager.INSTANCE.getEntityRecipe(entity, stack)) != null) {
            InteractionResult result = recipe.process(level, player, stack, entity);
            if (result.shouldSwing()) {
                player.getCooldowns().addCooldown((Item)this, 20);
            }
            return result;
        }
        return InteractionResult.FAIL;
    }
}

