/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.item;

import dev.compasses.expandedstorage.entity.ChestMinecart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ChestMinecartItem
extends Item {
    private static final DispenseItemBehavior DISPENSER_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DispenseItemBehavior defaultDispenserBehaviour = new DefaultDispenseItemBehavior();

        @NotNull
        public ItemStack execute(BlockSource block, ItemStack stack) {
            BlockState belowFrontState;
            Direction forward = (Direction)block.state().getValue((Property)DispenserBlock.FACING);
            double x = (double)block.pos().getX() + (double)forward.getStepX() * 1.125;
            double y = block.pos().getY() + forward.getStepY();
            double z = (double)block.pos().getZ() + (double)forward.getStepZ() * 1.125;
            BlockPos frontPos = block.pos().relative(forward);
            ServerLevel level = block.level();
            BlockState frontState = level.getBlockState(frontPos);
            double railHeight = -2.0;
            if (BaseRailBlock.isRail((BlockState)frontState)) {
                RailShape railShape = (RailShape)frontState.getValue(((BaseRailBlock)frontState.getBlock()).getShapeProperty());
                railHeight = railShape.isAscending() ? 0.5 : 0.0;
            } else if (frontState.isAir() && BaseRailBlock.isRail((BlockState)(belowFrontState = level.getBlockState(frontPos.below())))) {
                RailShape railShape = (RailShape)belowFrontState.getValue(((BaseRailBlock)belowFrontState.getBlock()).getShapeProperty());
                double d = railHeight = forward != Direction.DOWN && railShape.isAscending() ? -0.5 : -1.0;
            }
            if (railHeight == -2.0) {
                this.defaultDispenserBehaviour.dispense(block, stack);
            } else {
                Vec3 posVec = new Vec3(x, y + railHeight + 0.0625, z);
                ChestMinecart cart = ChestMinecart.createMinecart((Level)level, posVec, ((ChestMinecartItem)stack.getItem()).cartId);
                if (stack.has(DataComponents.CUSTOM_NAME)) {
                    cart.setCustomName(stack.getHoverName());
                }
                level.addFreshEntity((Entity)cart);
            }
            stack.shrink(1);
            return stack;
        }
    };
    public final ResourceLocation cartId;

    public ChestMinecartItem(Item.Properties properties, ResourceLocation cartId) {
        super(properties);
        this.cartId = cartId;
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)DISPENSER_BEHAVIOR);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos = context.getClickedPos());
        if (!BaseRailBlock.isRail((BlockState)state)) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = context.getItemInHand();
        if (!level.isClientSide()) {
            RailShape railShape = (RailShape)state.getValue(((BaseRailBlock)state.getBlock()).getShapeProperty());
            double railHeight = railShape.isAscending() ? 0.5 : 0.0;
            Vec3 posVec = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + railHeight + 0.0625, (double)pos.getZ() + 0.5);
            ChestMinecart cart = ChestMinecart.createMinecart(level, posVec, this.cartId);
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                cart.setCustomName(stack.getHoverName());
            }
            level.addFreshEntity((Entity)cart);
            level.gameEvent((Holder)GameEvent.ENTITY_PLACE, pos, GameEvent.Context.of((Entity)context.getPlayer(), (BlockState)level.getBlockState(pos.below())));
        }
        stack.shrink(1);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }
}

