/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.inventory.handler;

import compasses.expandedstorage.impl.CommonMain;
import compasses.expandedstorage.impl.inventory.handler.ToggleableSlot;
import java.util.function.IntUnaryOperator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class AbstractHandler
extends AbstractContainerMenu {
    private final Container inventory;
    private final ResourceLocation forcedScreenType;

    public AbstractHandler(int syncId, Container inventory, Inventory playerInventory, ResourceLocation forcedScreenType) {
        super(CommonMain.platformHelper().getScreenHandlerType(), syncId);
        this.inventory = inventory;
        this.forcedScreenType = forcedScreenType;
        inventory.startOpen(playerInventory.player);
        if (playerInventory.player instanceof ServerPlayer) {
            int i;
            for (i = 0; i < inventory.getContainerSize(); ++i) {
                this.addSlot(new Slot(inventory, i, i * 18, 0));
            }
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    this.addSlot(new Slot((Container)playerInventory, y * 9 + x + 9, 18 * x, y * 18));
                }
            }
            for (i = 0; i < 9; ++i) {
                this.addSlot(new Slot((Container)playerInventory, i, i * 18, 36));
            }
        }
    }

    public static AbstractHandler createClientMenu(int syncId, Inventory playerInventory, int slots, ResourceLocation forcedScreenType) {
        return new AbstractHandler(syncId, (Container)new SimpleContainer(slots), playerInventory, forcedScreenType);
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    public void removed(Player player) {
        super.removed(player);
        this.inventory.stopOpen(player);
    }

    public Container getInventory() {
        return this.inventory;
    }

    @NotNull
    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack originalStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack newStack = slot.getItem();
            originalStack = newStack.copy();
            if (index < this.inventory.getContainerSize() ? !this.moveItemStackTo(newStack, this.inventory.getContainerSize(), this.inventory.getContainerSize() + 36, true) : !this.moveItemStackTo(newStack, 0, this.inventory.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (newStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return originalStack;
    }

    public void resetSlotPositions(boolean createSlots, int menuWidth, int menuHeight) {
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            int realYPos;
            int slotXPos = i % menuWidth;
            int slotYPos = Mth.ceil((double)((double)(i - slotXPos) / (double)menuWidth));
            int n = realYPos = slotYPos >= menuHeight ? 18 * (slotYPos % menuHeight) - 2000 : slotYPos * 18;
            if (createSlots) {
                this.addSlot(new ToggleableSlot(this.inventory, i, slotXPos * 18 + 8, realYPos + 18, slotYPos < menuHeight));
                continue;
            }
            ((Slot)this.slots.get((int)i)).y = realYPos + 18;
        }
    }

    public void moveSlotRange(int minSlotIndex, int maxSlotIndex, int yDifference) {
        for (int i = minSlotIndex; i < maxSlotIndex; ++i) {
            ToggleableSlot slot = (ToggleableSlot)((Object)this.slots.get(i));
            slot.y += yDifference;
            if (yDifference != -2000 && yDifference != 2000) continue;
            slot.toggleActive();
        }
    }

    public void setSlotRange(int minSlotIndex, int maxSlotIndex, IntUnaryOperator yMutator) {
        for (int i = minSlotIndex; i < maxSlotIndex; ++i) {
            ToggleableSlot slot = (ToggleableSlot)((Object)this.slots.get(i));
            int newY = yMutator.applyAsInt(i);
            if (newY - slot.y > 1000 || slot.y - newY > 1000) {
                ((ToggleableSlot)((Object)this.slots.get(i))).toggleActive();
            }
            slot.y = newY;
        }
    }

    public void clearSlots() {
        this.slots.clear();
        this.remoteSlots.clear();
        this.lastSlots.clear();
    }

    public void addClientSlot(Slot slot) {
        this.addSlot(slot);
    }

    public ResourceLocation getForcedScreenType() {
        return this.forcedScreenType;
    }
}

