/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.inventory;

import compasses.expandedstorage.impl.inventory.handler.InventorySlotFunction;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.ObjIntConsumer;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VariableSidedInventory
implements WorldlyContainer {
    private final WorldlyContainer[] parts;
    private final int size;
    private final int maxStackCount;
    private final Map<Direction, int[]> slotsAccessibleThroughFace = new HashMap<Direction, int[]>();

    private VariableSidedInventory(WorldlyContainer ... parts) {
        for (int i = 0; i < parts.length; ++i) {
            assert (parts[i] != null) : "part at index " + i + " must not be null";
        }
        this.parts = parts;
        this.size = Arrays.stream(parts).mapToInt(Container::getContainerSize).sum();
        this.maxStackCount = parts[0].getMaxStackSize();
        for (WorldlyContainer part : parts) {
            assert (part.getMaxStackSize() == this.maxStackCount) : "all parts must have equal max stack counts.";
        }
    }

    public static WorldlyContainer of(WorldlyContainer ... parts) {
        assert (parts.length > 0) : "parts must contain at least 1 inventory";
        if (parts.length == 1) {
            return parts[0];
        }
        return new VariableSidedInventory(parts);
    }

    public int getContainerSize() {
        return this.size;
    }

    public boolean isEmpty() {
        for (WorldlyContainer part : this.parts) {
            if (part.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack getItem(int slot) {
        assert (slot >= 0 && slot < this.getContainerSize()) : "slot index out of range";
        return this.applyFunctionToSlot(slot, Container::getItem);
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        assert (slot >= 0 && slot < this.getContainerSize()) : "slot index out of range";
        return this.applyFunctionToSlot(slot, (part, rSlot) -> part.removeItem(rSlot, amount));
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        assert (slot >= 0 && slot < this.getContainerSize()) : "slot index out of range";
        return this.applyFunctionToSlot(slot, Container::removeItemNoUpdate);
    }

    public void setItem(int slot, ItemStack stack) {
        assert (slot >= 0 && slot < this.getContainerSize()) : "slot index out of range";
        this.consumeSlot(slot, (part, rSlot) -> part.setItem(rSlot, stack));
    }

    public int getMaxStackSize() {
        return this.maxStackCount;
    }

    public void setChanged() {
        for (WorldlyContainer part : this.parts) {
            part.setChanged();
        }
    }

    public boolean stillValid(Player player) {
        for (WorldlyContainer part : this.parts) {
            if (part.stillValid(player)) continue;
            return false;
        }
        return true;
    }

    public void startOpen(Player player) {
        for (WorldlyContainer part : this.parts) {
            part.startOpen(player);
        }
    }

    public void stopOpen(Player player) {
        for (WorldlyContainer part : this.parts) {
            part.stopOpen(player);
        }
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        assert (slot >= 0 && slot < this.getContainerSize()) : "slot index out of range";
        return this.applyFunctionToSlot(slot, (part, rSlot) -> part.canPlaceItem(rSlot, stack));
    }

    public int countItem(Item item) {
        int count = 0;
        for (WorldlyContainer part : this.parts) {
            count += part.countItem(item);
        }
        return count;
    }

    public boolean hasAnyOf(Set<Item> set) {
        for (WorldlyContainer part : this.parts) {
            if (!part.hasAnyOf(set)) continue;
            return true;
        }
        return false;
    }

    public void clearContent() {
        for (WorldlyContainer part : this.parts) {
            part.clearContent();
        }
    }

    public int @NotNull [] getSlotsForFace(Direction direction) {
        return this.slotsAccessibleThroughFace.computeIfAbsent(direction, dir -> {
            int previousSize = 0;
            IntArrayList list = new IntArrayList();
            for (WorldlyContainer part : this.parts) {
                for (int i : part.getSlotsForFace(dir)) {
                    list.add(i + previousSize);
                }
                previousSize += part.getContainerSize();
            }
            return list.toIntArray();
        });
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction direction) {
        assert (slot >= 0 && slot < this.getContainerSize()) : "slot index out of range";
        return this.applyFunctionToSlot(slot, (part, rSlot) -> part.canPlaceItemThroughFace(rSlot, stack, direction));
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction direction) {
        assert (slot >= 0 && slot < this.getContainerSize()) : "slot index out of range";
        return this.applyFunctionToSlot(slot, (part, rSlot) -> part.canTakeItemThroughFace(rSlot, stack, direction));
    }

    private void consumeSlot(int slot, ObjIntConsumer<WorldlyContainer> consumer) {
        for (WorldlyContainer part : this.parts) {
            int inventorySize = part.getContainerSize();
            if (slot >= inventorySize) {
                slot -= inventorySize;
                continue;
            }
            consumer.accept(part, slot);
            return;
        }
        throw new IllegalStateException("consumeSlot called without validating slot bounds.");
    }

    private <T> T applyFunctionToSlot(int slot, InventorySlotFunction<WorldlyContainer, T> function) {
        for (WorldlyContainer part : this.parts) {
            int inventorySize = part.getContainerSize();
            if (slot >= inventorySize) {
                slot -= inventorySize;
                continue;
            }
            return function.apply(part, slot);
        }
        throw new IllegalStateException("applyFunctionToSlot called without validating slot bounds.");
    }

    public boolean containsPart(WorldlyContainer part) {
        for (WorldlyContainer inventory : this.parts) {
            if (inventory != part) continue;
            return true;
        }
        return false;
    }
}

