/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.inventory;

import compasses.expandedstorage.impl.inventory.OpenableInventory;
import compasses.expandedstorage.impl.inventory.VariableSidedInventory;
import java.util.Arrays;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.WorldlyContainer;

public class OpenableInventories
implements OpenableInventory {
    private final OpenableInventory[] parts;
    private final WorldlyContainer inventory;
    private final Component inventoryTitle;

    private OpenableInventories(Component inventoryTitle, OpenableInventory ... parts) {
        this.parts = parts;
        this.inventory = VariableSidedInventory.of((WorldlyContainer[])Arrays.stream(parts).map(OpenableInventory::getInventory).toArray(WorldlyContainer[]::new));
        this.inventoryTitle = inventoryTitle;
    }

    public static OpenableInventory of(Component inventoryTitle, OpenableInventory ... parts) {
        return new OpenableInventories(inventoryTitle, parts);
    }

    @Override
    public boolean canBeUsedBy(ServerPlayer player) {
        for (OpenableInventory part : this.parts) {
            if (part.canBeUsedBy(player)) continue;
            return false;
        }
        return true;
    }

    @Override
    public WorldlyContainer getInventory() {
        return this.inventory;
    }

    @Override
    public Component getInventoryTitle() {
        return this.inventoryTitle;
    }
}

