/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.config;

import com.electronwill.nightconfig.core.Config;
import compasses.expandedstorage.impl.client.config.ConfigV0;
import compasses.expandedstorage.impl.client.config.Converter;
import compasses.expandedstorage.impl.misc.Utils;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class LegacyFactory
implements Converter<Config, ConfigV0> {
    public static final LegacyFactory INSTANCE = new LegacyFactory();

    private LegacyFactory() {
    }

    @Override
    @Nullable
    public ConfigV0 fromSource(@Nullable Config source) {
        Object object;
        if (source != null && (object = source.get("client.preferred_container_type")) instanceof String) {
            String screenType = (String)object;
            object = source.get("client.restrictive_scrolling");
            if (object instanceof Boolean) {
                Boolean restrictiveScrolling = (Boolean)object;
                if ("expandedstorage:paged".equals(screenType)) {
                    screenType = Utils.PAGINATED_SCREEN_TYPE.toString();
                } else if ("expandedstorage:scrollable".equals(screenType)) {
                    screenType = Utils.SCROLLABLE_SCREEN_TYPE.toString();
                }
                return new ConfigV0(ResourceLocation.tryParse((String)screenType), restrictiveScrolling, false, false);
            }
        }
        return null;
    }

    @Override
    public Config toSource(ConfigV0 target) {
        throw new UnsupportedOperationException("Legacy configs cannot be saved.");
    }

    @Override
    public int getSourceVersion() {
        return -1;
    }

    @Override
    public int getTargetVersion() {
        return 0;
    }
}

