/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import compasses.expandedstorage.impl.client.function.ScreenSize;
import compasses.expandedstorage.impl.client.gui.AbstractScreen;
import compasses.expandedstorage.impl.client.gui.TexturedRect;
import compasses.expandedstorage.impl.inventory.handler.AbstractHandler;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;

public final class SingleScreen
extends AbstractScreen {
    private final Set<TexturedRect> blankArea = new HashSet<TexturedRect>();
    private final int blankSlots;

    public SingleScreen(AbstractHandler handler, Inventory playerInventory, Component title, ScreenSize screenSize) {
        super(handler, playerInventory, title, screenSize);
        this.initializeSlots(playerInventory);
        this.blankSlots = this.inventoryWidth * this.inventoryHeight - this.totalSlots;
        this.imageWidth = 7 + 18 * this.inventoryWidth + 7;
        this.imageHeight = 17 + 18 * this.inventoryHeight + 14 + 54 + 4 + 18 + 7;
    }

    public static ScreenSize retrieveScreenSize(int slots, int scaledWidth, int scaledHeight) {
        int width;
        if (slots <= 81) {
            width = 9;
        } else if (slots <= 108) {
            width = 12;
        } else if (slots <= 135) {
            width = 15;
        } else if (slots <= 270) {
            width = 18;
        } else {
            return null;
        }
        int height = slots <= 27 ? 3 : (slots <= 45 ? 5 : (slots <= 54 ? 6 : (slots <= 162 ? 9 : (slots <= 216 ? 12 : 15))));
        return new ScreenSize(width, height);
    }

    protected void init() {
        super.init();
        if (this.blankSlots > 0) {
            this.blankArea.clear();
            int rows = Math.floorDiv(this.blankSlots, this.inventoryWidth);
            int remainder = this.blankSlots - this.inventoryWidth * rows;
            int yTop = this.topPos + 17 + (this.inventoryHeight - 1) * 18;
            int xLeft = this.leftPos + 7;
            for (int i = 0; i < rows; ++i) {
                this.blankArea.add(new TexturedRect(this.textureLocation, xLeft, yTop, this.inventoryWidth * 18, 18, 7, this.imageHeight, this.textureWidth, this.textureHeight));
                yTop -= 18;
            }
            if (remainder > 0) {
                int xRight = this.leftPos + 7 + this.inventoryWidth * 18;
                int width = remainder * 18;
                this.blankArea.add(new TexturedRect(this.textureLocation, xRight - width, yTop, width, 18, 7, this.imageHeight, this.textureWidth, this.textureHeight));
            }
        }
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int left, int top, int button) {
        int outsideRegion;
        if (this.inventoryWidth > 9 && mouseY >= (double)(top + 17 + this.inventoryHeight * 18 + 17) && (mouseX < (double)(left + (outsideRegion = (this.imageWidth - 176) / 2)) || mouseX > (double)(left + this.imageWidth - outsideRegion))) {
            return true;
        }
        return super.hasClickedOutside(mouseX, mouseY, left, top, button);
    }

    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blit(this.textureLocation, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.textureWidth, this.textureHeight);
        this.blankArea.forEach(image -> image.render(graphics));
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.title, 8, 6, 0x404040, false);
        graphics.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 96 + 2, 0x404040, false);
    }

    private void initializeSlots(Inventory playerInventory) {
        int y;
        for (int i = 0; i < ((AbstractHandler)this.menu).getInventory().getContainerSize(); ++i) {
            int x = i % this.inventoryWidth;
            y = (i - x) / this.inventoryWidth;
            ((AbstractHandler)this.menu).addClientSlot(new Slot(((AbstractHandler)this.menu).getInventory(), i, x * 18 + 8, y * 18 + 18));
        }
        int left = (this.inventoryWidth * 18 + 14) / 2 - 80;
        int top = 32 + this.inventoryHeight * 18;
        for (y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                ((AbstractHandler)this.menu).addClientSlot(new Slot((Container)playerInventory, y * 9 + x + 9, left + 18 * x, top + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            ((AbstractHandler)this.menu).addClientSlot(new Slot((Container)playerInventory, x, left + 18 * x, top + 58));
        }
    }
}

