/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.client.gui;

import com.google.common.collect.ImmutableSortedSet;
import compasses.expandedstorage.impl.CommonClient;
import compasses.expandedstorage.impl.client.gui.AbstractScreen;
import compasses.expandedstorage.impl.client.gui.widget.PickButton;
import compasses.expandedstorage.impl.client.gui.widget.ScreenPickButton;
import compasses.expandedstorage.impl.inventory.handler.AbstractHandler;
import compasses.expandedstorage.impl.misc.Utils;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class PickScreen
extends Screen {
    public static final Component CURRENT_OPTION_TEXT = Component.translatable((String)"screen.expandedstorage.current_option_notice").withStyle(ChatFormatting.GOLD);
    public static final Map<ResourceLocation, PickButton> BUTTON_SETTINGS = Map.of(Utils.PAGINATED_SCREEN_TYPE, new PickButton(Utils.id("textures/gui/page_button.png"), (Component)Component.translatable((String)"screen.expandedstorage.page_screen"), new Component[0]), Utils.SCROLLABLE_SCREEN_TYPE, new PickButton(Utils.id("textures/gui/scroll_button.png"), (Component)Component.translatable((String)"screen.expandedstorage.scroll_screen"), new Component[0]), Utils.SINGLE_SCREEN_TYPE, new PickButton(Utils.id("textures/gui/single_button.png"), (Component)Component.translatable((String)"screen.expandedstorage.single_screen"), new Component[]{Component.translatable((String)"screen.expandedstorage.off_screen_warning_1").withStyle(ChatFormatting.GRAY), Component.translatable((String)"screen.expandedstorage.off_screen_warning_2").withStyle(ChatFormatting.GRAY)}){

        @Override
        public boolean shouldShowWarning(int scaledWidth, int scaledHeight) {
            return scaledWidth < 370 || scaledHeight < 386;
        }
    });
    private final Set<ResourceLocation> options = ImmutableSortedSet.copyOf(BUTTON_SETTINGS.keySet());
    private final Supplier<Screen> returnToScreen;
    private final AbstractHandler handler;
    private int topPadding;

    public PickScreen(AbstractScreen currentScreen) {
        this((AbstractHandler)currentScreen.getMenu(), () -> AbstractScreen.createScreen((AbstractHandler)currentScreen.getMenu(), Minecraft.getInstance().player.getInventory(), currentScreen.getTitle()));
    }

    public PickScreen(Screen returnToScreen) {
        this(null, () -> returnToScreen);
    }

    private PickScreen(@Nullable AbstractHandler handler, Supplier<Screen> returnToScreen) {
        super((Component)Component.translatable((String)"screen.expandedstorage.screen_picker_title"));
        this.handler = handler;
        this.returnToScreen = returnToScreen;
    }

    public void onClose() {
        if (this.handler != null) {
            ResourceLocation preference = CommonClient.platformHelper().configWrapper().getPreferredScreenType();
            if (preference == null) {
                this.minecraft.player.closeContainer();
                return;
            }
            if (AbstractScreen.getScreenSize(preference, this.handler.getInventory().getContainerSize(), this.minecraft.getWindow().getGuiScaledWidth(), this.minecraft.getWindow().getGuiScaledHeight()) == null) {
                this.minecraft.player.displayClientMessage((Component)Component.translatable((String)"text.expandedstorage.short_prefix").withStyle(ChatFormatting.GOLD).append((Component)Component.translatable((String)"chat.expandedstorage.cannot_display_screen", (Object[])new Object[]{Component.translatable((String)("screen." + preference.getNamespace() + "." + preference.getPath() + "_screen"))}).withStyle(ChatFormatting.WHITE)), false);
                this.minecraft.player.closeContainer();
                return;
            }
            this.handler.clearSlots();
        }
        this.minecraft.setScreen(this.returnToScreen.get());
    }

    public boolean isPauseScreen() {
        return this.minecraft.level == null;
    }

    protected void init() {
        int topPadding;
        super.init();
        ResourceLocation preference = CommonClient.platformHelper().configWrapper().getPreferredScreenType();
        int choices = this.options.size();
        int columns = Math.min(Math.floorDiv(this.width, 96), choices);
        int innerPadding = Math.min((this.width - columns * 96) / (columns + 1), 20);
        int outerPadding = (this.width - ((columns - 1) * innerPadding + columns * 96)) / 2;
        int x = 0;
        this.topPadding = topPadding = (this.height - 96) / 2;
        for (ResourceLocation option : this.options) {
            PickButton settings = BUTTON_SETTINGS.get(option);
            boolean isWarn = settings.shouldShowWarning(this.width, this.height);
            boolean isCurrent = option.equals((Object)preference);
            MutableComponent tooltipMessage = Component.literal((String)"").append(settings.getTitle());
            if (isCurrent) {
                tooltipMessage.append("\n");
                tooltipMessage.append(CURRENT_OPTION_TEXT);
            }
            if (isWarn) {
                tooltipMessage.append("\n");
                settings.getWarningText().forEach(arg_0 -> ((MutableComponent)tooltipMessage).append(arg_0));
            }
            this.addRenderableWidget((GuiEventListener)new ScreenPickButton(outerPadding + (innerPadding + 96) * x, topPadding, 96, 96, settings.getTexture(), settings.getTitle(), isWarn, isCurrent, __ -> this.updatePlayerPreference(option), Tooltip.create((Component)tooltipMessage, (Component)tooltipMessage)));
            ++x;
        }
    }

    private void updatePlayerPreference(ResourceLocation selection) {
        CommonClient.platformHelper().configWrapper().setPreferredScreenType(selection);
        this.onClose();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, Math.max(this.topPadding / 2, 0), -1);
    }
}

