/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import compasses.expandedstorage.impl.CommonClient;
import compasses.expandedstorage.impl.client.function.ScreenSize;
import compasses.expandedstorage.impl.client.gui.AbstractScreen;
import compasses.expandedstorage.impl.client.gui.TexturedRect;
import compasses.expandedstorage.impl.client.gui.widget.PageButton;
import compasses.expandedstorage.impl.inventory.handler.AbstractHandler;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;

public final class PageScreen
extends AbstractScreen {
    private final Set<TexturedRect> blankArea = new LinkedHashSet<TexturedRect>();
    private final int blankSlots;
    private final int pages;
    private PageButton leftPageButton;
    private PageButton rightPageButton;
    private int page = 1;
    private MutableComponent currentPageText;
    private float pageTextX;

    public PageScreen(AbstractHandler handler, Inventory playerInventory, Component title, ScreenSize screenSize) {
        super(handler, playerInventory, title, screenSize);
        this.initializeSlots(playerInventory);
        int slotsPerPage = this.inventoryWidth * this.inventoryHeight;
        this.pages = Mth.ceil((double)((double)this.totalSlots / (double)slotsPerPage));
        int lastPageSlots = this.totalSlots - (this.pages - 1) * slotsPerPage;
        this.blankSlots = slotsPerPage - lastPageSlots;
        this.imageWidth = 7 + 18 * this.inventoryWidth + 7;
        this.imageHeight = 17 + 18 * this.inventoryHeight + 14 + 54 + 4 + 18 + 7;
    }

    protected void init() {
        super.init();
        this.recalculateBlankArea();
    }

    private static boolean regionIntersects(AbstractWidget widget, int x, int y, int width, int height) {
        int left = widget.getX();
        int right = left + widget.getWidth();
        int top = widget.getY();
        int bottom = top + widget.getHeight();
        return (left >= x && left <= x + width || right >= x && right <= x + width) && (top >= y && top <= y + height || bottom >= y && bottom <= y + height);
    }

    public static ScreenSize retrieveScreenSize(int slots, int scaledWidth, int scaledHeight) {
        if (CommonClient.platformHelper().configWrapper().fitVanillaConstraints()) {
            return new ScreenSize(9, 6);
        }
        ArrayList<Pair<ScreenSize, ScreenSize>> options = new ArrayList<Pair<ScreenSize, ScreenSize>>();
        PageScreen.addEntry(options, slots, 9, 3);
        PageScreen.addEntry(options, slots, 9, 6);
        if (scaledHeight >= 276 && slots > 54) {
            PageScreen.addEntry(options, slots, 9, 9);
        }
        if (slots > 90) {
            PageScreen.addEntry(options, slots, 15, 6);
        }
        Pair<ScreenSize, ScreenSize> picked = options.get(0);
        for (int i = 1; i < options.size(); ++i) {
            Pair<ScreenSize, ScreenSize> option = options.get(i);
            int currentPages = ((ScreenSize)picked.getSecond()).width();
            int currentBlankSlots = ((ScreenSize)picked.getSecond()).height();
            int currentWidth = ((ScreenSize)picked.getFirst()).width();
            int newPages = ((ScreenSize)option.getSecond()).width();
            int newBlankSlots = ((ScreenSize)option.getSecond()).height();
            int newWidth = ((ScreenSize)option.getFirst()).width();
            int newHeight = ((ScreenSize)option.getFirst()).height();
            if (newBlankSlots <= currentBlankSlots && newPages < currentPages && currentWidth == newWidth) {
                picked = option;
                continue;
            }
            if (CommonClient.platformHelper().configWrapper().preferSmallerScreens() && currentPages == newPages + 1 && (double)newBlankSlots < (double)(newWidth * newHeight) / 2.0 || newPages >= currentPages || !((double)newBlankSlots < (double)(newWidth * newHeight) / 2.0)) continue;
            picked = option;
        }
        return (ScreenSize)picked.getFirst();
    }

    private static void addEntry(ArrayList<Pair<ScreenSize, ScreenSize>> options, int slots, int width, int height) {
        int pages = Mth.ceil((double)((double)slots / (double)(width * height)));
        int blanked = slots - pages * width * height;
        options.add((Pair<ScreenSize, ScreenSize>)new Pair((Object)new ScreenSize(width, height), (Object)new ScreenSize(pages, blanked)));
    }

    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blit(this.textureLocation, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.textureWidth, this.textureHeight);
        if (this.page == this.pages) {
            this.blankArea.forEach(image -> image.render(graphics));
        }
    }

    private void initializeSlots(Inventory playerInventory) {
        ((AbstractHandler)this.menu).resetSlotPositions(true, this.inventoryWidth, this.inventoryHeight);
        int playerInvLeft = (this.inventoryWidth * 18 + 14) / 2 - 80;
        int playerInvTop = 32 + this.inventoryHeight * 18;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                ((AbstractHandler)this.menu).addClientSlot(new Slot((Container)playerInventory, y * 9 + x + 9, playerInvLeft + 18 * x, playerInvTop + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            ((AbstractHandler)this.menu).addClientSlot(new Slot((Container)playerInventory, x, playerInvLeft + 18 * x, playerInvTop + 58));
        }
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int left, int top, int button) {
        int outsideRegion;
        if (this.inventoryWidth > 9 && mouseY >= (double)(top + 17 + this.inventoryHeight * 18 + 17) && (mouseX < (double)(left + (outsideRegion = (this.imageWidth - 176) / 2)) || mouseX > (double)(left + this.imageWidth - outsideRegion))) {
            return true;
        }
        return super.hasClickedOutside(mouseX, mouseY, left, top, button);
    }

    private void setPage(int oldPage, int newPage) {
        if (newPage == 0 || newPage > this.pages) {
            return;
        }
        this.page = newPage;
        if (newPage > oldPage) {
            if (this.page == this.pages) {
                this.rightPageButton.setActive(false);
            }
            if (!this.leftPageButton.active) {
                this.leftPageButton.setActive(true);
            }
        } else if (newPage < oldPage) {
            if (this.page == 1) {
                this.leftPageButton.setActive(false);
            }
            if (!this.rightPageButton.active) {
                this.rightPageButton.setActive(true);
            }
        }
        int slotsPerPage = this.inventoryWidth * this.inventoryHeight;
        int oldMin = slotsPerPage * (oldPage - 1);
        int oldMax = Math.min(oldMin + slotsPerPage, this.totalSlots);
        ((AbstractHandler)this.menu).moveSlotRange(oldMin, oldMax, -2000);
        int newMin = slotsPerPage * (newPage - 1);
        int newMax = Math.min(newMin + slotsPerPage, this.totalSlots);
        ((AbstractHandler)this.menu).moveSlotRange(newMin, newMax, 2000);
        this.setPageText();
    }

    private void setPageText() {
        this.currentPageText = Component.translatable((String)"screen.expandedstorage.page_x_y", (Object[])new Object[]{this.page, this.pages});
        this.pageTextX = (float)(this.leftPageButton.getX() + this.leftPageButton.getWidth() + this.rightPageButton.getX()) / 2.0f - (float)this.font.width((FormattedText)this.currentPageText) / 2.0f + 0.5f;
    }

    private void recalculateBlankArea() {
        if (this.blankSlots > 0) {
            this.blankArea.clear();
            int rows = Math.floorDiv(this.blankSlots, this.inventoryWidth);
            int remainder = this.blankSlots - this.inventoryWidth * rows;
            int yTop = this.topPos + 17 + (this.inventoryHeight - 1) * 18;
            int xLeft = this.leftPos + 7;
            for (int i = 0; i < rows; ++i) {
                this.blankArea.add(new TexturedRect(this.textureLocation, xLeft, yTop, this.inventoryWidth * 18, 18, 7, this.imageHeight, this.textureWidth, this.textureHeight));
                yTop -= 18;
            }
            if (remainder > 0) {
                int xRight = this.leftPos + 7 + this.inventoryWidth * 18;
                int width = remainder * 18;
                this.blankArea.add(new TexturedRect(this.textureLocation, xRight - width, yTop, width, 18, 7, this.imageHeight, this.textureWidth, this.textureHeight));
            }
        }
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.title, 8, 6, 0x404040, false);
        graphics.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 96 + 2, 0x404040, false);
        if (this.currentPageText != null) {
            graphics.drawString(this.font, this.currentPageText.getVisualOrderText(), (int)(this.pageTextX - (float)this.leftPos), this.imageHeight - 94, 0x404040, false);
        }
    }

    @Override
    protected boolean handleKeyPress(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 262 || keyCode == 267) {
            this.setPage(this.page, PageScreen.hasShiftDown() ? this.pages : this.page + 1);
            return true;
        }
        if (keyCode == 263 || keyCode == 266) {
            this.setPage(this.page, PageScreen.hasShiftDown() ? 1 : this.page - 1);
            return true;
        }
        return false;
    }

    public void addPageButtons() {
        int x;
        int width = 54;
        int originalX = x = this.leftPos + this.imageWidth - 61;
        int y = this.topPos + this.imageHeight - 96;
        ArrayList<AbstractWidget> renderableChildren = new ArrayList<AbstractWidget>();
        for (GuiEventListener child : this.children()) {
            if (!(child instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)child;
            renderableChildren.add(widget);
        }
        renderableChildren.sort(Comparator.comparingInt(a -> -a.getX()));
        for (AbstractWidget widget : renderableChildren) {
            if (!PageScreen.regionIntersects(widget, x, y, width, 12)) continue;
            x = widget.getX() - width - 2;
        }
        if (x == originalX && (CommonClient.platformHelper().isModLoaded("inventoryprofiles") || CommonClient.platformHelper().isModLoaded("inventoryprofilesnext"))) {
            x -= 14;
        }
        this.leftPageButton = new PageButton(x, y, 0, (Component)Component.translatable((String)"screen.expandedstorage.prev_page"), button -> this.setPage(this.page, this.page - 1));
        this.leftPageButton.active = this.page != 1;
        this.addRenderableWidget((GuiEventListener)this.leftPageButton);
        this.rightPageButton = new PageButton(x + 42, y, 1, (Component)Component.translatable((String)"screen.expandedstorage.next_page"), button -> this.setPage(this.page, this.page + 1));
        this.rightPageButton.active = this.page != this.pages;
        this.addRenderableWidget((GuiEventListener)this.rightPageButton);
        this.setPageText();
    }
}

