/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.client.gui;

import com.google.common.collect.ImmutableSortedSet;
import compasses.expandedstorage.impl.CommonClient;
import compasses.expandedstorage.impl.client.function.ScreenSize;
import compasses.expandedstorage.impl.client.gui.AbstractScreen;
import compasses.expandedstorage.impl.client.gui.PickScreen;
import compasses.expandedstorage.impl.client.gui.widget.PickButton;
import compasses.expandedstorage.impl.client.gui.widget.ScreenPickButton;
import compasses.expandedstorage.impl.inventory.handler.AbstractHandler;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;

public final class FakePickScreen
extends AbstractScreen {
    private static final Component TITLE = Component.translatable((String)"screen.expandedstorage.screen_picker_title");
    private final Set<ResourceLocation> options = ImmutableSortedSet.copyOf(PickScreen.BUTTON_SETTINGS.keySet());
    private int topPadding;

    public FakePickScreen(AbstractHandler handler, Inventory playerInventory, Component title) {
        super(handler, playerInventory, title, new ScreenSize(0, 0));
        for (int i = 0; i < ((AbstractHandler)this.menu).getInventory().getContainerSize(); ++i) {
            ((AbstractHandler)this.menu).addClientSlot(new Slot(((AbstractHandler)this.menu).getInventory(), i, 0, 0));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                ((AbstractHandler)this.menu).addClientSlot(new Slot((Container)playerInventory, y * 9 + x + 9, 0, 0));
            }
        }
        for (int x = 0; x < 9; ++x) {
            ((AbstractHandler)this.menu).addClientSlot(new Slot((Container)playerInventory, x, 0, 0));
        }
    }

    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
    }

    public void onClose() {
        ResourceLocation preference = CommonClient.platformHelper().configWrapper().getPreferredScreenType();
        if (preference == null) {
            this.minecraft.player.closeContainer();
        } else {
            int invSize = ((AbstractHandler)this.menu).getInventory().getContainerSize();
            if (FakePickScreen.getScreenSize(preference, invSize, this.minecraft.getWindow().getGuiScaledWidth(), this.minecraft.getWindow().getGuiScaledHeight()) == null) {
                this.minecraft.player.displayClientMessage((Component)Component.translatable((String)"text.expandedstorage.short_prefix").withStyle(ChatFormatting.GOLD).append((Component)Component.translatable((String)"chat.expandedstorage.cannot_display_screen", (Object[])new Object[]{Component.translatable((String)("screen." + preference.getNamespace() + "." + preference.getPath() + "_screen"))}).withStyle(ChatFormatting.WHITE)), false);
                this.minecraft.player.closeContainer();
                return;
            }
            ((AbstractHandler)this.menu).clearSlots();
            this.minecraft.setScreen((Screen)FakePickScreen.createScreen((AbstractHandler)this.menu, Minecraft.getInstance().player.getInventory(), this.getTitle()));
        }
    }

    protected void init() {
        int topPadding;
        super.init();
        ResourceLocation preference = CommonClient.platformHelper().configWrapper().getPreferredScreenType();
        int choices = this.options.size();
        int columns = Math.min(Math.floorDiv(this.width, 96), choices);
        int innerPadding = Math.min((this.width - columns * 96) / (columns + 1), 20);
        int outerPadding = (this.width - ((columns - 1) * innerPadding + columns * 96)) / 2;
        int x = 0;
        this.topPadding = topPadding = (this.height - 96) / 2;
        for (ResourceLocation option : this.options) {
            PickButton settings = PickScreen.BUTTON_SETTINGS.get(option);
            boolean isWarn = settings.shouldShowWarning(this.width, this.height);
            boolean isCurrent = option.equals((Object)preference);
            MutableComponent tooltipMessage = Component.literal((String)"").append(settings.getTitle());
            if (isCurrent) {
                tooltipMessage.append("\n");
                tooltipMessage.append(PickScreen.CURRENT_OPTION_TEXT);
            }
            if (isWarn) {
                tooltipMessage.append("\n");
                settings.getWarningText().forEach(arg_0 -> ((MutableComponent)tooltipMessage).append(arg_0));
            }
            this.addRenderableWidget((GuiEventListener)new ScreenPickButton(outerPadding + (innerPadding + 96) * x, topPadding, 96, 96, settings.getTexture(), settings.getTitle(), isWarn, isCurrent, __ -> this.updatePlayerPreference(option), Tooltip.create((Component)tooltipMessage)));
            ++x;
        }
    }

    private void updatePlayerPreference(ResourceLocation selection) {
        CommonClient.platformHelper().configWrapper().setPreferredScreenType(selection);
        this.onClose();
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphics, mouseX, mouseY, delta);
        for (Renderable widget : this.renderables) {
            widget.render(graphics, mouseX, mouseY, delta);
        }
        graphics.drawCenteredString(this.font, TITLE, this.width / 2, Math.max(this.topPadding / 2, 0), -1);
    }
}

