/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.client;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.compasses.expandedstorage.entity.ChestMinecart;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class ChestCartClientExtensions
implements IClientItemExtensions {
    private final Supplier<BlockEntityWithoutLevelRenderer> renderer = Suppliers.memoize(() -> {
        Minecraft minecraft = Minecraft.getInstance();
        this.renderers = entityTypes.entrySet().stream().map(entry -> Map.entry((Item)entry.getKey(), (ChestMinecart)((EntityType)entry.getValue()).create((Level)minecraft.level))).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        return new BlockEntityWithoutLevelRenderer(minecraft.getBlockEntityRenderDispatcher(), minecraft.getEntityModels()){

            public void renderByItem(ItemStack itemStack, ItemDisplayContext context, PoseStack stack, MultiBufferSource source, int light, int overlay) {
                ChestMinecart renderEntity = ChestCartClientExtensions.this.renderers.get(itemStack.getItem());
                Minecraft.getInstance().getEntityRenderDispatcher().render((Entity)renderEntity, 0.0, 0.0, 0.0, 0.0f, 0.0f, stack, source, light);
            }
        };
    });
    private Map<Item, ChestMinecart> renderers;

    public ChestCartClientExtensions(Map<Item, EntityType<ChestMinecart>> entityTypes) {
    }

    public BlockEntityWithoutLevelRenderer getCustomRenderer() {
        return this.renderer.get();
    }
}

