/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import compasses.expandedstorage.api.EsChestType;
import compasses.expandedstorage.impl.CommonMain;
import compasses.expandedstorage.impl.block.AbstractChestBlock;
import compasses.expandedstorage.impl.block.ChestBlock;
import compasses.expandedstorage.impl.block.entity.ChestBlockEntity;
import compasses.expandedstorage.impl.block.misc.PropertyRetriever;
import compasses.expandedstorage.impl.misc.Utils;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public final class ChestBlockEntityRenderer
implements BlockEntityRenderer<ChestBlockEntity> {
    public static final ModelLayerLocation SINGLE_LAYER = new ModelLayerLocation(Utils.id("single_chest"), "main");
    public static final ModelLayerLocation LEFT_LAYER = new ModelLayerLocation(Utils.id("left_chest"), "main");
    public static final ModelLayerLocation RIGHT_LAYER = new ModelLayerLocation(Utils.id("right_chest"), "main");
    public static final ModelLayerLocation TOP_LAYER = new ModelLayerLocation(Utils.id("top_chest"), "main");
    public static final ModelLayerLocation BOTTOM_LAYER = new ModelLayerLocation(Utils.id("bottom_chest"), "main");
    public static final ModelLayerLocation FRONT_LAYER = new ModelLayerLocation(Utils.id("front_chest"), "main");
    public static final ModelLayerLocation BACK_LAYER = new ModelLayerLocation(Utils.id("back_chest"), "main");
    private static final BlockState DEFAULT_STATE = ((Block)BuiltInRegistries.BLOCK.get(Utils.id("wood_chest"))).defaultBlockState();
    private static final compasses.expandedstorage.impl.block.misc.Property<ChestBlockEntity, Float2FloatFunction> LID_OPENNESS_FUNCTION_GETTER = new compasses.expandedstorage.impl.block.misc.Property<ChestBlockEntity, Float2FloatFunction>(){

        @Override
        public Float2FloatFunction get(ChestBlockEntity first, ChestBlockEntity second) {
            return delta -> Math.max(first.getLidOpenness(delta), second.getLidOpenness(delta));
        }

        @Override
        public Float2FloatFunction get(ChestBlockEntity single) {
            return single::getLidOpenness;
        }
    };
    private static final compasses.expandedstorage.impl.block.misc.Property<ChestBlockEntity, Int2IntFunction> BRIGHTNESS_PROPERTY = new compasses.expandedstorage.impl.block.misc.Property<ChestBlockEntity, Int2IntFunction>(){

        @Override
        public Int2IntFunction get(ChestBlockEntity first, ChestBlockEntity second) {
            return i -> {
                int firstLightColor = LevelRenderer.getLightColor((BlockAndTintGetter)first.getLevel(), (BlockPos)first.getBlockPos());
                int firstBlockLight = LightTexture.block((int)firstLightColor);
                int firstSkyLight = LightTexture.sky((int)firstLightColor);
                int secondLightColor = LevelRenderer.getLightColor((BlockAndTintGetter)second.getLevel(), (BlockPos)second.getBlockPos());
                int secondBlockLight = LightTexture.block((int)secondLightColor);
                int secondSkyLight = LightTexture.sky((int)secondLightColor);
                return LightTexture.pack((int)Math.max(firstBlockLight, secondBlockLight), (int)Math.max(firstSkyLight, secondSkyLight));
            };
        }

        @Override
        public Int2IntFunction get(ChestBlockEntity single) {
            return i -> i;
        }
    };
    private final ModelPart singleBottom;
    private final ModelPart singleLid;
    private final ModelPart singleLock;
    private final ModelPart leftBottom;
    private final ModelPart leftLid;
    private final ModelPart leftLock;
    private final ModelPart rightBottom;
    private final ModelPart rightLid;
    private final ModelPart rightLock;
    private final ModelPart topBottom;
    private final ModelPart topLid;
    private final ModelPart topLock;
    private final ModelPart bottomBottom;
    private final ModelPart frontBottom;
    private final ModelPart frontLid;
    private final ModelPart frontLock;
    private final ModelPart backBottom;
    private final ModelPart backLid;

    public ChestBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart single = context.bakeLayer(SINGLE_LAYER);
        this.singleBottom = single.getChild("bottom");
        this.singleLid = single.getChild("lid");
        this.singleLock = single.getChild("lock");
        ModelPart left = context.bakeLayer(LEFT_LAYER);
        this.leftBottom = left.getChild("bottom");
        this.leftLid = left.getChild("lid");
        this.leftLock = left.getChild("lock");
        ModelPart right = context.bakeLayer(RIGHT_LAYER);
        this.rightBottom = right.getChild("bottom");
        this.rightLid = right.getChild("lid");
        this.rightLock = right.getChild("lock");
        ModelPart top = context.bakeLayer(TOP_LAYER);
        this.topBottom = top.getChild("bottom");
        this.topLid = top.getChild("lid");
        this.topLock = top.getChild("lock");
        ModelPart bottom = context.bakeLayer(BOTTOM_LAYER);
        this.bottomBottom = bottom.getChild("bottom");
        ModelPart front = context.bakeLayer(FRONT_LAYER);
        this.frontBottom = front.getChild("bottom");
        this.frontLid = front.getChild("lid");
        this.frontLock = front.getChild("lock");
        ModelPart back = context.bakeLayer(BACK_LAYER);
        this.backBottom = back.getChild("bottom");
        this.backLid = back.getChild("lid");
    }

    public static LayerDefinition createSingleBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("bottom", CubeListBuilder.create().texOffs(0, 19).addBox(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f), PartPose.ZERO);
        partDefinition.addOrReplaceChild("lid", CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        partDefinition.addOrReplaceChild("lock", CubeListBuilder.create().texOffs(0, 0).addBox(7.0f, -2.0f, 14.0f, 2.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)48);
    }

    public static LayerDefinition createLeftBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("bottom", CubeListBuilder.create().texOffs(0, 19).addBox(1.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f), PartPose.ZERO);
        partDefinition.addOrReplaceChild("lid", CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        partDefinition.addOrReplaceChild("lock", CubeListBuilder.create().texOffs(0, 0).addBox(15.0f, -2.0f, 14.0f, 1.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)48);
    }

    public static LayerDefinition createRightBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("bottom", CubeListBuilder.create().texOffs(0, 19).addBox(0.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f), PartPose.ZERO);
        partDefinition.addOrReplaceChild("lid", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        partDefinition.addOrReplaceChild("lock", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -2.0f, 14.0f, 1.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)48);
    }

    public static LayerDefinition createTopBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("bottom", CubeListBuilder.create().texOffs(0, 19).addBox(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f), PartPose.ZERO);
        partDefinition.addOrReplaceChild("lid", CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        partDefinition.addOrReplaceChild("lock", CubeListBuilder.create().texOffs(0, 0).addBox(7.0f, -2.0f, 14.0f, 2.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)48);
    }

    public static LayerDefinition createBottomBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("bottom", CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, 0.0f, 1.0f, 14.0f, 16.0f, 14.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public static LayerDefinition createFrontBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("bottom", CubeListBuilder.create().texOffs(0, 20).addBox(1.0f, 0.0f, 0.0f, 14.0f, 10.0f, 15.0f), PartPose.ZERO);
        partDefinition.addOrReplaceChild("lid", CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, 0.0f, 15.0f, 14.0f, 5.0f, 15.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)-15.0f));
        partDefinition.addOrReplaceChild("lock", CubeListBuilder.create().texOffs(0, 0).addBox(7.0f, -2.0f, 30.0f, 2.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)-15.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)48);
    }

    public static LayerDefinition createBackBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("bottom", CubeListBuilder.create().texOffs(0, 20).addBox(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 15.0f), PartPose.ZERO);
        partDefinition.addOrReplaceChild("lid", CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 15.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)48, (int)48);
    }

    private static float getLidOpenness(float delta) {
        delta = 1.0f - delta;
        delta = 1.0f - delta * delta * delta;
        return -delta * 1.5707964f;
    }

    private static void renderBottom(PoseStack stack, VertexConsumer consumer, ModelPart bottom, int light, int overlay) {
        bottom.render(stack, consumer, light, overlay);
    }

    private static void renderTop(PoseStack stack, VertexConsumer consumer, ModelPart top, int light, int overlay, float openness) {
        top.xRot = openness;
        top.render(stack, consumer, light, overlay);
    }

    public void render(ChestBlockEntity entity, float delta, PoseStack stack, MultiBufferSource provider, int light, int overlay) {
        Block block;
        BlockState state;
        ResourceLocation blockId = entity.getBlockId();
        BlockState blockState = state = entity.hasLevel() ? entity.getBlockState() : (BlockState)DEFAULT_STATE.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH);
        if (blockId == null || !((block = state.getBlock()) instanceof ChestBlock)) {
            return;
        }
        ChestBlock block2 = (ChestBlock)block;
        EsChestType chestType = (EsChestType)((Object)state.getValue(AbstractChestBlock.CURSED_CHEST_TYPE));
        stack.pushPose();
        stack.translate(0.5, 0.5, 0.5);
        int yOffset = entity.isDinnerbone() ? 180 : 0;
        stack.mulPose(Axis.YP.rotationDegrees(-((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot()));
        if (yOffset == 180) {
            stack.mulPose(Axis.ZP.rotationDegrees((float)yOffset));
            if (chestType == EsChestType.LEFT) {
                chestType = EsChestType.RIGHT;
            } else if (chestType == EsChestType.RIGHT) {
                chestType = EsChestType.LEFT;
            } else if (chestType == EsChestType.TOP) {
                chestType = EsChestType.BOTTOM;
            } else if (chestType == EsChestType.BOTTOM) {
                chestType = EsChestType.TOP;
            }
        }
        stack.translate(-0.5, -0.5, -0.5);
        PropertyRetriever<ChestBlockEntity> retriever = entity.hasLevel() ? AbstractChestBlock.createPropertyRetriever(block2, state, (LevelAccessor)entity.getLevel(), entity.getBlockPos(), true) : PropertyRetriever.createDirect(entity);
        VertexConsumer consumer = new Material(Sheets.CHEST_SHEET, CommonMain.getChestTexture(blockId, chestType)).buffer(provider, RenderType::entityCutout);
        float lidOpenness = ChestBlockEntityRenderer.getLidOpenness(retriever.get(LID_OPENNESS_FUNCTION_GETTER).orElse(f -> 0.0f).get(delta));
        int brightness = retriever.get(BRIGHTNESS_PROPERTY).orElse(i -> i).applyAsInt(light);
        if (chestType == EsChestType.SINGLE) {
            ChestBlockEntityRenderer.renderBottom(stack, consumer, this.singleBottom, brightness, overlay);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.singleLid, brightness, overlay, lidOpenness);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.singleLock, brightness, overlay, lidOpenness);
        } else if (chestType == EsChestType.TOP) {
            ChestBlockEntityRenderer.renderBottom(stack, consumer, this.topBottom, brightness, overlay);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.topLid, brightness, overlay, lidOpenness);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.topLock, brightness, overlay, lidOpenness);
        } else if (chestType == EsChestType.BOTTOM) {
            ChestBlockEntityRenderer.renderBottom(stack, consumer, this.bottomBottom, brightness, overlay);
        } else if (chestType == EsChestType.FRONT) {
            ChestBlockEntityRenderer.renderBottom(stack, consumer, this.frontBottom, brightness, overlay);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.frontLid, brightness, overlay, lidOpenness);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.frontLock, brightness, overlay, lidOpenness);
        } else if (chestType == EsChestType.BACK) {
            ChestBlockEntityRenderer.renderBottom(stack, consumer, this.backBottom, brightness, overlay);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.backLid, brightness, overlay, lidOpenness);
        } else if (chestType == EsChestType.LEFT) {
            ChestBlockEntityRenderer.renderBottom(stack, consumer, this.leftBottom, brightness, overlay);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.leftLid, brightness, overlay, lidOpenness);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.leftLock, brightness, overlay, lidOpenness);
        } else if (chestType == EsChestType.RIGHT) {
            ChestBlockEntityRenderer.renderBottom(stack, consumer, this.rightBottom, brightness, overlay);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.rightLid, brightness, overlay, lidOpenness);
            ChestBlockEntityRenderer.renderTop(stack, consumer, this.rightLock, brightness, overlay, lidOpenness);
        }
        stack.popPose();
    }
}

