/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.block.entity;

import compasses.expandedstorage.api.EsChestType;
import compasses.expandedstorage.impl.block.AbstractChestBlock;
import compasses.expandedstorage.impl.block.entity.OldChestBlockEntity;
import compasses.expandedstorage.impl.block.strategies.ItemAccess;
import compasses.expandedstorage.impl.block.strategies.Lockable;
import compasses.expandedstorage.impl.inventory.VariableSidedInventory;
import compasses.expandedstorage.impl.inventory.handler.AbstractHandler;
import dev.compasses.expandedstorage.block.entity.BaseBlockEntity;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public final class ChestBlockEntity
extends OldChestBlockEntity {
    private final ContainerOpenersCounter manager = new ContainerOpenersCounter(){

        protected void onOpen(Level level, BlockPos pos, BlockState state) {
            ChestBlockEntity.playSound(level, pos, state, SoundEvents.CHEST_OPEN);
        }

        protected void onClose(Level level, BlockPos pos, BlockState state) {
            ChestBlockEntity.playSound(level, pos, state, SoundEvents.CHEST_CLOSE);
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int oldCount, int newCount) {
            level.blockEvent(pos, state.getBlock(), 1, newCount);
        }

        protected boolean isOwnContainer(Player player) {
            VariableSidedInventory variableInventory;
            AbstractHandler handler;
            WorldlyContainer inventory = ChestBlockEntity.this.getInventory();
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            return abstractContainerMenu instanceof AbstractHandler && ((handler = (AbstractHandler)abstractContainerMenu).getInventory() == inventory || (abstractContainerMenu = handler.getInventory()) instanceof VariableSidedInventory && (variableInventory = (VariableSidedInventory)abstractContainerMenu).containsPart(inventory));
        }
    };
    private final ChestLidController lidController = new ChestLidController();

    public ChestBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, Function<BaseBlockEntity, ItemAccess<?>> access, Supplier<Lockable> lockable) {
        super(type, pos, state, access, lockable);
    }

    public void startOpen(Player player) {
        if (player.isSpectator() || this.isRemoved()) {
            return;
        }
        this.manager.incrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
    }

    public void stopOpen(Player player) {
        if (player.isSpectator() || this.isRemoved()) {
            return;
        }
        this.manager.decrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
    }

    public static void progressLidAnimation(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        ((ChestBlockEntity)blockEntity).lidController.tickLid();
    }

    private static void playSound(Level level, BlockPos pos, BlockState state, SoundEvent sound) {
        Vec3 soundPos;
        DoubleBlockCombiner.BlockType mergeType = AbstractChestBlock.getBlockType((EsChestType)((Object)state.getValue(AbstractChestBlock.CURSED_CHEST_TYPE)));
        if (mergeType == DoubleBlockCombiner.BlockType.SINGLE) {
            soundPos = Vec3.atCenterOf((Vec3i)pos);
        } else if (mergeType == DoubleBlockCombiner.BlockType.FIRST) {
            soundPos = Vec3.atCenterOf((Vec3i)pos).add(Vec3.atLowerCornerOf((Vec3i)AbstractChestBlock.getDirectionToAttached(state).getNormal()).scale(0.5));
        } else {
            return;
        }
        level.playSound(null, soundPos.x(), soundPos.y(), soundPos.z(), sound, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
    }

    public boolean triggerEvent(int event, int value) {
        if (event == 1) {
            this.lidController.shouldBeOpen(value > 0);
            return true;
        }
        return super.triggerEvent(event, value);
    }

    public float getLidOpenness(float delta) {
        return this.lidController.getOpenness(delta);
    }

    public void updateViewerCount(ServerLevel level, BlockPos pos, BlockState state) {
        this.manager.recheckOpeners((Level)level, pos, state);
    }
}

