/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.block.entity;

import compasses.expandedstorage.impl.block.strategies.ItemAccess;
import compasses.expandedstorage.impl.block.strategies.Lockable;
import compasses.expandedstorage.impl.inventory.handler.AbstractHandler;
import dev.compasses.expandedstorage.block.entity.BaseBlockEntity;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public final class BarrelBlockEntity
extends BaseBlockEntity {
    private final ContainerOpenersCounter manager = new ContainerOpenersCounter(){

        protected void onOpen(Level level, BlockPos pos, BlockState state) {
            BarrelBlockEntity.playSound(level, state, pos, SoundEvents.BARREL_OPEN);
            BarrelBlockEntity.updateBlockState(level, state, pos, true);
        }

        protected void onClose(Level level, BlockPos pos, BlockState state) {
            BarrelBlockEntity.playSound(level, state, pos, SoundEvents.BARREL_CLOSE);
            BarrelBlockEntity.updateBlockState(level, state, pos, false);
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int oldCount, int newCount) {
        }

        protected boolean isOwnContainer(Player player) {
            AbstractHandler handler;
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            return abstractContainerMenu instanceof AbstractHandler && (handler = (AbstractHandler)abstractContainerMenu).getInventory() == BarrelBlockEntity.this;
        }
    };

    public BarrelBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, Function<BaseBlockEntity, ItemAccess<?>> access, Supplier<Lockable> lockable) {
        super(type, pos, state, access, lockable);
    }

    private static void playSound(Level level, BlockState state, BlockPos pos, SoundEvent sound) {
        Vec3i facingVector = ((Direction)state.getValue((Property)BlockStateProperties.FACING)).getNormal();
        double X = (double)pos.getX() + 0.5 + (double)facingVector.getX() / 2.0;
        double Y = (double)pos.getY() + 0.5 + (double)facingVector.getY() / 2.0;
        double Z = (double)pos.getZ() + 0.5 + (double)facingVector.getZ() / 2.0;
        level.playSound(null, X, Y, Z, sound, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
    }

    private static void updateBlockState(Level level, BlockState state, BlockPos pos, boolean open) {
        level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(open)), 3);
    }

    public void startOpen(Player player) {
        if (player.isSpectator() || this.isRemoved()) {
            return;
        }
        this.manager.incrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
    }

    public void stopOpen(Player player) {
        if (player.isSpectator() || this.isRemoved()) {
            return;
        }
        this.manager.decrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
    }

    public void updateViewerCount(ServerLevel level, BlockPos pos, BlockState state) {
        this.manager.recheckOpeners((Level)level, pos, state);
    }
}

