/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.block;

import com.google.common.collect.BiMap;
import compasses.expandedstorage.impl.CommonMain;
import compasses.expandedstorage.impl.block.misc.CopperBlockHelper;
import compasses.expandedstorage.impl.client.helpers.InventoryOpeningApi;
import compasses.expandedstorage.impl.inventory.OpenableInventoryProvider;
import compasses.expandedstorage.impl.inventory.context.BlockContext;
import compasses.expandedstorage.impl.registration.ModBlocks;
import dev.compasses.expandedstorage.block.entity.BaseBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OpenableBlock
extends Block
implements OpenableInventoryProvider<BlockContext>,
EntityBlock {
    private final ResourceLocation openingStat;
    private final int slotCount;

    public OpenableBlock(BlockBehaviour.Properties settings, ResourceLocation openingStat, int slotCount) {
        super(settings);
        this.openingStat = openingStat;
        this.slotCount = slotCount;
    }

    public Component getInventoryTitle() {
        BiMap<Block, Block> dewaxingMap = CopperBlockHelper.dewaxing();
        if (dewaxingMap.containsKey((Object)this)) {
            return ((Block)dewaxingMap.get((Object)this)).getName();
        }
        return this.getName();
    }

    public final ResourceLocation getBlockId() {
        return this.builtInRegistryHolder().key().location();
    }

    public final int getSlotCount() {
        return this.slotCount;
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        if (this == ModBlocks.BAMBOO_CHEST && CommonMain.platformHelper().canDestroyBamboo(player.getMainHandItem())) {
            return 1.0f;
        }
        return super.getDestroyProgress(state, player, level, pos);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean bl) {
        BlockEntity blockEntity;
        if (state.getBlock().getClass() != newState.getBlock().getClass()) {
            BlockEntity blockEntity2 = level.getBlockEntity(pos);
            if (blockEntity2 instanceof BaseBlockEntity) {
                BaseBlockEntity entity = (BaseBlockEntity)blockEntity2;
                Containers.dropContents((Level)level, (BlockPos)pos, entity.getItems());
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, bl);
        } else if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof BaseBlockEntity) {
            BaseBlockEntity entity = (BaseBlockEntity)blockEntity;
            CompoundTag tag = entity.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
            level.removeBlockEntity(pos);
            BlockEntity blockEntity3 = level.getBlockEntity(pos);
            if (blockEntity3 instanceof BaseBlockEntity) {
                BaseBlockEntity newEntity = (BaseBlockEntity)blockEntity3;
                newEntity.loadWithComponents(tag, (HolderLookup.Provider)level.registryAccess());
            }
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.has(DataComponents.CUSTOM_NAME) && (blockEntity = level.getBlockEntity(pos)) instanceof BaseBlockEntity) {
            BaseBlockEntity entity = (BaseBlockEntity)blockEntity;
            entity.setCustomName(stack.getHoverName());
        }
    }

    @Override
    public void onInitialOpen(ServerPlayer player) {
        player.awardStat(this.openingStat);
        if (!player.level().isClientSide()) {
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        boolean isClient = level.isClientSide();
        if (!isClient) {
            InventoryOpeningApi.openBlockInventory((ServerPlayer)player, pos, this);
        }
        return InteractionResult.sidedSuccess((boolean)isClient);
    }
}

