/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.block;

import compasses.expandedstorage.impl.CommonMain;
import compasses.expandedstorage.impl.block.OpenableBlock;
import compasses.expandedstorage.impl.inventory.OpenableInventory;
import compasses.expandedstorage.impl.inventory.context.BlockContext;
import compasses.expandedstorage.impl.misc.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MiniStorageBlock
extends OpenableBlock
implements SimpleWaterloggedBlock,
Equipable {
    private static final VoxelShape NO_RIBBON_NO_SPARROW = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    private static final VoxelShape RIBBON_NO_SPARROW = Shapes.or((VoxelShape)NO_RIBBON_NO_SPARROW, (VoxelShape)Block.box((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0));
    private static final VoxelShape NO_RIBBON_SPARROW_NS = Shapes.or((VoxelShape)NO_RIBBON_NO_SPARROW, (VoxelShape)Block.box((double)6.0, (double)8.0, (double)5.0, (double)10.0, (double)13.0, (double)11.0));
    private static final VoxelShape NO_RIBBON_SPARROW_EW = Shapes.or((VoxelShape)NO_RIBBON_NO_SPARROW, (VoxelShape)Block.box((double)5.0, (double)8.0, (double)6.0, (double)11.0, (double)13.0, (double)10.0));
    private static final VoxelShape RIBBON_SPARROW_NS = Shapes.or((VoxelShape)NO_RIBBON_NO_SPARROW, (VoxelShape)Block.box((double)6.0, (double)8.0, (double)5.0, (double)10.0, (double)14.0, (double)11.0));
    private static final VoxelShape RIBBON_SPARROW_EW = Shapes.or((VoxelShape)NO_RIBBON_NO_SPARROW, (VoxelShape)Block.box((double)5.0, (double)8.0, (double)6.0, (double)11.0, (double)14.0, (double)10.0));
    public static final BooleanProperty SPARROW = BooleanProperty.create((String)"sparrow");
    private final boolean hasRibbon;

    public MiniStorageBlock(BlockBehaviour.Properties settings, ResourceLocation openingStat, boolean hasRibbon) {
        super(settings, openingStat, 1);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)SPARROW, (Comparable)Boolean.valueOf(false)));
        this.hasRibbon = hasRibbon;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter blockLevel, BlockPos pos, CollisionContext context) {
        boolean hasSparrow;
        boolean bl = hasSparrow = state.hasProperty((Property)SPARROW) && (Boolean)state.getValue((Property)SPARROW) != false;
        if (this.hasRibbon) {
            if (hasSparrow) {
                return ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).get2DDataValue() % 2 == 0 ? RIBBON_SPARROW_NS : RIBBON_SPARROW_EW;
            }
            return RIBBON_NO_SPARROW;
        }
        if (hasSparrow) {
            return ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).get2DDataValue() % 2 == 0 ? NO_RIBBON_SPARROW_NS : NO_RIBBON_SPARROW_EW;
        }
        return NO_RIBBON_NO_SPARROW;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean placingInWater = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        boolean isSparrowItem = MiniStorageBlock.hasSparrowProperty(context.getItemInHand());
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(placingInWater))).setValue((Property)SPARROW, (Comparable)Boolean.valueOf(isSparrowItem));
    }

    public static boolean hasSparrowProperty(ItemStack stack) {
        if (stack.has(DataComponents.BLOCK_STATE)) {
            BlockItemStateProperties properties = (BlockItemStateProperties)stack.get(DataComponents.BLOCK_STATE);
            return Boolean.TRUE.equals(properties.get((Property)SPARROW));
        }
        return false;
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.WATERLOGGED, SPARROW});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return CommonMain.getMiniStorageBlockEntityType().create(pos, state);
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(pos));
    }

    @Override
    public OpenableInventory getOpenableInventory(BlockContext context) {
        BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getBlockPos());
        if (blockEntity instanceof OpenableInventory) {
            OpenableInventory inventory = (OpenableInventory)blockEntity;
            return inventory;
        }
        return null;
    }

    @Override
    public ResourceLocation getForcedScreenType() {
        return Utils.MINI_STORAGE_SCREEN_TYPE;
    }

    @NotNull
    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.HEAD;
    }
}

