/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.block;

import compasses.expandedstorage.impl.block.BarrelBlock;
import compasses.expandedstorage.impl.block.misc.CopperBlockHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public final class CopperBarrelBlock
extends BarrelBlock
implements WeatheringCopper {
    private final WeatheringCopper.WeatherState weatherState;

    public CopperBarrelBlock(BlockBehaviour.Properties settings, ResourceLocation openingStat, int slotCount, WeatheringCopper.WeatherState weatherState) {
        super(settings, openingStat, slotCount);
        this.weatherState = weatherState;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return CopperBlockHelper.getNextOxidisedState(state).isPresent();
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.changeOverTime(state, level, pos, random);
    }

    @NotNull
    public Optional<BlockState> getNext(BlockState state) {
        return CopperBlockHelper.getNextOxidisedState(state);
    }

    @NotNull
    public WeatheringCopper.WeatherState getAge() {
        return this.weatherState;
    }
}

