/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.block;

import compasses.expandedstorage.api.EsChestType;
import compasses.expandedstorage.impl.CommonMain;
import compasses.expandedstorage.impl.block.AbstractChestBlock;
import compasses.expandedstorage.impl.block.entity.ChestBlockEntity;
import compasses.expandedstorage.impl.block.entity.OldChestBlockEntity;
import dev.compasses.expandedstorage.block.entity.BaseBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChestBlock
extends AbstractChestBlock
implements SimpleWaterloggedBlock {
    public static final int SET_OBSERVER_COUNT_EVENT = 1;
    private static final VoxelShape[] SHAPES = new VoxelShape[]{ChestBlock.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)15.0), ChestBlock.box((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0), ChestBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)16.0), ChestBlock.box((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0), ChestBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0), ChestBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), ChestBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0)};
    private static final VoxelShape[] UPSIDE_DOWN_SHAPES = new VoxelShape[]{ChestBlock.box((double)1.0, (double)2.0, (double)0.0, (double)15.0, (double)16.0, (double)15.0), ChestBlock.box((double)1.0, (double)2.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), ChestBlock.box((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)16.0, (double)16.0), ChestBlock.box((double)0.0, (double)2.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), ChestBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), ChestBlock.box((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), ChestBlock.box((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)};

    public ChestBlock(BlockBehaviour.Properties settings, ResourceLocation openingStat, int slotCount) {
        super(settings, openingStat, slotCount);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter blockLevel, BlockPos pos, CollisionContext context) {
        boolean upsideDown = false;
        BlockEntity blockEntity = blockLevel.getBlockEntity(pos);
        if (blockEntity instanceof BaseBlockEntity) {
            BaseBlockEntity entity = (BaseBlockEntity)blockEntity;
            upsideDown = entity.isDinnerbone();
        }
        EsChestType type = (EsChestType)((Object)state.getValue((Property)CURSED_CHEST_TYPE));
        if (upsideDown) {
            if (type == EsChestType.TOP) {
                return UPSIDE_DOWN_SHAPES[4];
            }
            if (type == EsChestType.BOTTOM) {
                return UPSIDE_DOWN_SHAPES[5];
            }
            if (type == EsChestType.SINGLE) {
                return UPSIDE_DOWN_SHAPES[6];
            }
            int index = (((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).get2DDataValue() + type.getOffset()) % 4;
            return UPSIDE_DOWN_SHAPES[index];
        }
        if (type == EsChestType.TOP) {
            return SHAPES[4];
        }
        if (type == EsChestType.BOTTOM) {
            return SHAPES[5];
        }
        if (type == EsChestType.SINGLE) {
            return SHAPES[6];
        }
        int index = (((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).get2DDataValue() + type.getOffset()) % 4;
        return SHAPES[index];
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
    }

    @Override
    @NotNull
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)super.getStateForPlacement(context).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Override
    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState otherState, LevelAccessor level, BlockPos pos, BlockPos otherPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, otherState, level, pos, otherPos);
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Override
    protected <T extends OldChestBlockEntity> BlockEntityType<T> getBlockEntityType() {
        return CommonMain.getChestBlockEntityType();
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide() && blockEntityType == this.getBlockEntityType() ? ChestBlockEntity::progressLidAnimation : null;
    }

    public boolean triggerEvent(BlockState state, Level level, BlockPos pos, int event, int value) {
        super.triggerEvent(state, level, pos, event, value);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        return blockEntity != null && blockEntity.triggerEvent(event, value);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ChestBlockEntity) {
            ChestBlockEntity entity = (ChestBlockEntity)blockEntity;
            entity.updateViewerCount(level, pos, state);
        }
    }

    @Override
    public boolean isAccessBlocked(LevelAccessor level, BlockPos pos) {
        BaseBlockEntity entity;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BaseBlockEntity && (entity = (BaseBlockEntity)blockEntity).isDinnerbone()) {
            BlockPos belowPos = pos.below();
            return level.getBlockState(belowPos).isRedstoneConductor((BlockGetter)level, belowPos);
        }
        return net.minecraft.world.level.block.ChestBlock.isChestBlockedAt((LevelAccessor)level, (BlockPos)pos);
    }

    @Override
    protected boolean areChestsCompatible(Level level, ItemStack itemInHand, BlockPos firstPos, BlockPos secondPos) {
        BaseBlockEntity second;
        boolean firstIsDinnerbone = itemInHand.getHoverName().getString().equals("Dinnerbone");
        BlockEntity blockEntity = level.getBlockEntity(secondPos);
        boolean secondIsDinnerbone = blockEntity instanceof BaseBlockEntity && (second = (BaseBlockEntity)blockEntity).isDinnerbone();
        return firstIsDinnerbone == secondIsDinnerbone;
    }
}

