/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.block;

import compasses.expandedstorage.impl.CommonMain;
import compasses.expandedstorage.impl.block.OpenableBlock;
import compasses.expandedstorage.impl.block.entity.BarrelBlockEntity;
import compasses.expandedstorage.impl.inventory.OpenableInventory;
import compasses.expandedstorage.impl.inventory.context.BlockContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BarrelBlock
extends OpenableBlock {
    public BarrelBlock(BlockBehaviour.Properties settings, ResourceLocation openingStat, int slotCount) {
        super(settings, openingStat, slotCount);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP)).setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getPlayer() == null) {
            return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP);
        }
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)context.getNearestLookingDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.FACING, BlockStateProperties.OPEN});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return CommonMain.getBarrelBlockEntityType().create(pos, state);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BarrelBlockEntity) {
            BarrelBlockEntity entity = (BarrelBlockEntity)blockEntity;
            entity.updateViewerCount(level, pos, state);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(pos));
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)BlockStateProperties.FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)BlockStateProperties.FACING)));
    }

    @Override
    public OpenableInventory getOpenableInventory(BlockContext context) {
        BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getBlockPos());
        if (blockEntity instanceof OpenableInventory) {
            OpenableInventory inventory = (OpenableInventory)blockEntity;
            return inventory;
        }
        return null;
    }
}

