/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.block;

import compasses.expandedstorage.api.EsChestType;
import compasses.expandedstorage.impl.CommonMain;
import compasses.expandedstorage.impl.block.OpenableBlock;
import compasses.expandedstorage.impl.block.entity.OldChestBlockEntity;
import compasses.expandedstorage.impl.block.misc.Property;
import compasses.expandedstorage.impl.block.misc.PropertyRetriever;
import compasses.expandedstorage.impl.inventory.OpenableInventories;
import compasses.expandedstorage.impl.inventory.OpenableInventory;
import compasses.expandedstorage.impl.inventory.context.BlockContext;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractChestBlock
extends OpenableBlock
implements WorldlyContainerHolder {
    public static final EnumProperty<EsChestType> CURSED_CHEST_TYPE = EnumProperty.create((String)"type", EsChestType.class);
    private static final Property<OldChestBlockEntity, WorldlyContainer> INVENTORY_GETTER = new Property<OldChestBlockEntity, WorldlyContainer>(){

        @Override
        public WorldlyContainer get(OldChestBlockEntity first, OldChestBlockEntity second) {
            WorldlyContainer cachedInventory = first.getCachedDoubleInventory();
            if (cachedInventory == null) {
                first.setCachedDoubleInventory(second);
                return first.getCachedDoubleInventory();
            }
            return cachedInventory;
        }

        @Override
        public WorldlyContainer get(OldChestBlockEntity single) {
            return single.getInventory();
        }
    };

    public AbstractChestBlock(BlockBehaviour.Properties settings, ResourceLocation openingStat, int slotCount) {
        super(settings, openingStat, slotCount);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(CURSED_CHEST_TYPE, (Comparable)((Object)EsChestType.SINGLE))).setValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    public static <T extends OldChestBlockEntity> PropertyRetriever<T> createPropertyRetriever(AbstractChestBlock block, BlockState state, LevelAccessor level, BlockPos pos, boolean retrieveBlockedChests) {
        BiPredicate<LevelAccessor, BlockPos> isChestBlocked = retrieveBlockedChests ? (_world, _pos) -> false : block::isAccessBlocked;
        return PropertyRetriever.create(block.getBlockEntityType(), s -> AbstractChestBlock.getBlockType((EsChestType)((Object)((Object)s.getValue(CURSED_CHEST_TYPE)))), (s, facing) -> AbstractChestBlock.getDirectionToAttached((EsChestType)((Object)((Object)s.getValue(CURSED_CHEST_TYPE))), facing), s -> (Direction)s.getValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.HORIZONTAL_FACING), state, level, pos, isChestBlocked);
    }

    public static Direction getDirectionToAttached(EsChestType type, Direction facing) {
        if (type == EsChestType.TOP) {
            return Direction.DOWN;
        }
        if (type == EsChestType.BACK) {
            return facing;
        }
        if (type == EsChestType.RIGHT) {
            return facing.getClockWise();
        }
        if (type == EsChestType.BOTTOM) {
            return Direction.UP;
        }
        if (type == EsChestType.FRONT) {
            return facing.getOpposite();
        }
        if (type == EsChestType.LEFT) {
            return facing.getCounterClockWise();
        }
        if (type == EsChestType.SINGLE) {
            throw new IllegalArgumentException("AbstractChestBlock#getDirectionToAttached received an unexpected chest type.");
        }
        throw new IllegalArgumentException("AbstractChestBlock#getDirectionToAttached received an unknown chest type.");
    }

    public static Direction getDirectionToAttached(BlockState state) {
        return AbstractChestBlock.getDirectionToAttached((EsChestType)((Object)state.getValue(CURSED_CHEST_TYPE)), (Direction)state.getValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.HORIZONTAL_FACING));
    }

    public static DoubleBlockCombiner.BlockType getBlockType(EsChestType type) {
        if (type == EsChestType.TOP || type == EsChestType.LEFT || type == EsChestType.FRONT) {
            return DoubleBlockCombiner.BlockType.FIRST;
        }
        if (type == EsChestType.BACK || type == EsChestType.RIGHT || type == EsChestType.BOTTOM) {
            return DoubleBlockCombiner.BlockType.SECOND;
        }
        if (type == EsChestType.SINGLE) {
            return DoubleBlockCombiner.BlockType.SINGLE;
        }
        throw new IllegalArgumentException("Invalid EsChestType passed.");
    }

    public static EsChestType getChestType(Direction facing, Direction offset) {
        if (facing.getClockWise() == offset) {
            return EsChestType.RIGHT;
        }
        if (facing.getCounterClockWise() == offset) {
            return EsChestType.LEFT;
        }
        if (facing == offset) {
            return EsChestType.BACK;
        }
        if (facing == offset.getOpposite()) {
            return EsChestType.FRONT;
        }
        if (offset == Direction.DOWN) {
            return EsChestType.TOP;
        }
        if (offset == Direction.UP) {
            return EsChestType.BOTTOM;
        }
        return EsChestType.SINGLE;
    }

    public boolean isAccessBlocked(LevelAccessor level, BlockPos pos) {
        return false;
    }

    protected <T extends OldChestBlockEntity> BlockEntityType<T> getBlockEntityType() {
        return CommonMain.getOldChestBlockEntityType();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new net.minecraft.world.level.block.state.properties.Property[]{CURSED_CHEST_TYPE});
        builder.add(new net.minecraft.world.level.block.state.properties.Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.getBlockEntityType().create(pos, state);
    }

    @NotNull
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction chestForwardDir;
        EsChestType chestType;
        block2: {
            BlockPos pos;
            Level level;
            block1: {
                level = context.getLevel();
                pos = context.getClickedPos();
                chestType = EsChestType.SINGLE;
                chestForwardDir = context.getHorizontalDirection().getOpposite();
                Direction clickedFace = context.getClickedFace();
                if (!context.isSecondaryUseActive()) break block1;
                Direction offsetDir = clickedFace.getOpposite();
                BlockState offsetState = level.getBlockState(pos.relative(offsetDir));
                if (!offsetState.is((Block)this) || offsetState.getValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.HORIZONTAL_FACING) != chestForwardDir || offsetState.getValue(CURSED_CHEST_TYPE) != EsChestType.SINGLE || !this.areChestsCompatible(level, context.getItemInHand(), pos, pos.relative(offsetDir))) break block2;
                chestType = AbstractChestBlock.getChestType(chestForwardDir, offsetDir);
                break block2;
            }
            for (Direction dir : Direction.values()) {
                EsChestType type;
                BlockState offsetState = level.getBlockState(pos.relative(dir));
                if (!offsetState.is((Block)this) || offsetState.getValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.HORIZONTAL_FACING) != chestForwardDir || offsetState.getValue(CURSED_CHEST_TYPE) != EsChestType.SINGLE || (type = AbstractChestBlock.getChestType(chestForwardDir, dir)) == EsChestType.SINGLE || !this.areChestsCompatible(level, context.getItemInHand(), pos, pos.relative(dir))) continue;
                chestType = type;
                break;
            }
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)chestForwardDir)).setValue(CURSED_CHEST_TYPE, (Comparable)((Object)chestType));
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction offset, BlockState offsetState, LevelAccessor level, BlockPos pos, BlockPos offsetPos) {
        if (offsetState.is((Block)this)) {
            EsChestType offsetType = (EsChestType)((Object)offsetState.getValue(CURSED_CHEST_TYPE));
            if (state.getValue(CURSED_CHEST_TYPE) == EsChestType.SINGLE && offsetType != EsChestType.SINGLE && state.getValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.HORIZONTAL_FACING) == offsetState.getValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.HORIZONTAL_FACING) && AbstractChestBlock.getDirectionToAttached(offsetState) == offset.getOpposite()) {
                return (BlockState)state.setValue(CURSED_CHEST_TYPE, (Comparable)((Object)offsetType.getOpposite()));
            }
        } else if (state.getValue(CURSED_CHEST_TYPE) != EsChestType.SINGLE && AbstractChestBlock.getDirectionToAttached(state) == offset) {
            return (BlockState)state.setValue(CURSED_CHEST_TYPE, (Comparable)((Object)EsChestType.SINGLE));
        }
        return super.updateShape(state, offset, offsetState, level, pos, offsetPos);
    }

    @Nullable
    public WorldlyContainer getContainer(BlockState state, LevelAccessor level, BlockPos pos) {
        return AbstractChestBlock.createPropertyRetriever(this, state, level, pos, true).get(INVENTORY_GETTER).orElse(null);
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        EsChestType chestType = (EsChestType)((Object)state.getValue(CURSED_CHEST_TYPE));
        if (chestType == EsChestType.SINGLE || chestType == EsChestType.BOTTOM || chestType == EsChestType.TOP) {
            return state.rotate(mirror.getRotation((Direction)state.getValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.HORIZONTAL_FACING)));
        }
        return super.mirror(state, mirror);
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        EsChestType chestType = (EsChestType)((Object)state.getValue(CURSED_CHEST_TYPE));
        if (chestType == EsChestType.SINGLE || chestType == EsChestType.BOTTOM || chestType == EsChestType.TOP) {
            return (BlockState)state.setValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)rotation.rotate((Direction)state.getValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.HORIZONTAL_FACING)));
        }
        if (rotation == Rotation.CLOCKWISE_180) {
            return (BlockState)state.setValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)state.getValue((net.minecraft.world.level.block.state.properties.Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite());
        }
        return super.rotate(state, rotation);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        WorldlyContainer inventory = this.getContainer(state, (LevelAccessor)level, pos);
        if (inventory != null) {
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)inventory);
        }
        return super.getAnalogOutputSignal(state, level, pos);
    }

    @Override
    public OpenableInventory getOpenableInventory(BlockContext context) {
        ServerLevel level = context.getLevel();
        BlockPos pos = context.getBlockPos();
        BlockState state = level.getBlockState(pos);
        return AbstractChestBlock.createPropertyRetriever(this, state, (LevelAccessor)level, pos, false).get(new Property<OldChestBlockEntity, OpenableInventory>(this){

            @Override
            public OpenableInventory get(OldChestBlockEntity first, OldChestBlockEntity second) {
                Component name = first.hasCustomName() ? first.getName() : (second.hasCustomName() ? second.getName() : Component.translatable((String)"container.expandedstorage.generic_double", (Object[])new Object[]{first.getName()}));
                return OpenableInventories.of(name, first, second);
            }

            @Override
            public OpenableInventory get(OldChestBlockEntity single) {
                return single;
            }
        }).orElse(null);
    }

    @Override
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean bl) {
        if (state.hasProperty(CURSED_CHEST_TYPE) && newState.hasProperty(CURSED_CHEST_TYPE)) {
            EsChestType oldChestType = (EsChestType)((Object)state.getValue(CURSED_CHEST_TYPE));
            EsChestType newChestType = (EsChestType)((Object)newState.getValue(CURSED_CHEST_TYPE));
            if (oldChestType != EsChestType.SINGLE && newChestType == EsChestType.SINGLE) {
                BlockEntity blockEntity;
                if (AbstractChestBlock.getBlockType(oldChestType) == DoubleBlockCombiner.BlockType.FIRST && (blockEntity = level.getBlockEntity(pos)) instanceof OldChestBlockEntity) {
                    OldChestBlockEntity entity = (OldChestBlockEntity)blockEntity;
                    entity.invalidateDoubleBlockCache();
                }
                level.updateNeighbourForOutputSignal(pos, newState.getBlock());
            } else if (oldChestType == EsChestType.SINGLE && newChestType != EsChestType.SINGLE) {
                BlockPos otherPos = pos.relative(AbstractChestBlock.getDirectionToAttached(newState));
                level.updateNeighbourForOutputSignal(otherPos, level.getBlockState(otherPos).getBlock());
            }
        }
        super.onRemove(state, level, pos, newState, bl);
    }

    protected boolean areChestsCompatible(Level level, ItemStack itemInHand, BlockPos firstPos, BlockPos secondPos) {
        return true;
    }
}

