/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl;

import compasses.expandedstorage.impl.CommonClient;
import compasses.expandedstorage.impl.CommonMain;
import compasses.expandedstorage.impl.ForgeMain;
import compasses.expandedstorage.impl.block.ChestBlock;
import compasses.expandedstorage.impl.block.entity.ChestBlockEntity;
import compasses.expandedstorage.impl.client.ChestBlockClientExtensions;
import compasses.expandedstorage.impl.client.ChestBlockEntityRenderer;
import compasses.expandedstorage.impl.client.ChestCartClientExtensions;
import compasses.expandedstorage.impl.client.gui.AbstractScreen;
import compasses.expandedstorage.impl.client.gui.PageScreen;
import compasses.expandedstorage.impl.client.gui.PickScreen;
import compasses.expandedstorage.impl.item.ChestMinecartItem;
import compasses.expandedstorage.impl.misc.ForgeClientHelper;
import compasses.expandedstorage.impl.misc.Utils;
import compasses.expandedstorage.impl.registration.Content;
import compasses.expandedstorage.impl.registration.ModItems;
import compasses.expandedstorage.impl.registration.NamedValue;
import dev.compasses.expandedstorage.entity.ChestMinecart;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.MinecartRenderer;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="expandedstorage", dist={Dist.CLIENT})
public class ForgeClient {
    public ForgeClient(IEventBus bus, ModContainer mod) {
        ForgeMain mainEntryPoint = (ForgeMain)mod.getCustomExtension(ForgeMain.class).orElseThrow();
        Content content = mainEntryPoint.getContentForClient();
        CommonClient.initialize(new ForgeClientHelper(bus));
        ModLoadingContext.get().getActiveContainer().registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(container, screen) -> new PickScreen(screen)));
        NeoForge.EVENT_BUS.addListener(EventPriority.LOW, event -> {
            Screen patt0$temp = event.getScreen();
            if (patt0$temp instanceof PageScreen) {
                PageScreen screen = (PageScreen)patt0$temp;
                screen.addPageButtons();
            }
        });
        bus.addListener(event -> {
            ItemProperties.registerGeneric((ResourceLocation)Utils.id("sparrow"), (ItemPropertyFunction)((ClampedItemPropertyFunction)CommonClient::hasSparrowProperty));
            ItemProperties.register((Item)ModItems.STORAGE_MUTATOR, (ResourceLocation)Utils.id("tool_mode"), (ItemPropertyFunction)((ClampedItemPropertyFunction)CommonClient::currentMutatorToolMode));
        });
        bus.addListener(event -> event.register(CommonMain.platformHelper().getScreenHandlerType(), AbstractScreen::createScreen));
        bus.addListener(event -> event.registerBlockEntityRenderer(content.getChestBlockEntityType().getValue(), ChestBlockEntityRenderer::new));
        bus.addListener(event -> {
            event.registerLayerDefinition(ChestBlockEntityRenderer.SINGLE_LAYER, ChestBlockEntityRenderer::createSingleBodyLayer);
            event.registerLayerDefinition(ChestBlockEntityRenderer.LEFT_LAYER, ChestBlockEntityRenderer::createLeftBodyLayer);
            event.registerLayerDefinition(ChestBlockEntityRenderer.RIGHT_LAYER, ChestBlockEntityRenderer::createRightBodyLayer);
            event.registerLayerDefinition(ChestBlockEntityRenderer.TOP_LAYER, ChestBlockEntityRenderer::createTopBodyLayer);
            event.registerLayerDefinition(ChestBlockEntityRenderer.BOTTOM_LAYER, ChestBlockEntityRenderer::createBottomBodyLayer);
            event.registerLayerDefinition(ChestBlockEntityRenderer.FRONT_LAYER, ChestBlockEntityRenderer::createFrontBodyLayer);
            event.registerLayerDefinition(ChestBlockEntityRenderer.BACK_LAYER, ChestBlockEntityRenderer::createBackBodyLayer);
        });
        bus.addListener(event -> {
            for (NamedValue<EntityType<ChestMinecart>> type : content.getChestMinecartEntityTypes()) {
                event.registerEntityRenderer(type.getValue(), context -> new MinecartRenderer(context, ModelLayers.CHEST_MINECART));
            }
        });
        bus.addListener(event -> {
            Map<ChestBlock, ChestBlockEntity> blockRenderers = content.getChestBlocks().stream().map(NamedValue::getValue).map(block -> Map.entry(block, (ChestBlockEntity)CommonMain.getChestBlockEntityType().create(BlockPos.ZERO, block.defaultBlockState()))).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
            event.registerItem((IClientItemExtensions)new ChestBlockClientExtensions(blockRenderers), (Item[])content.getChestItems().stream().map(NamedValue::getValue).toArray(Item[]::new));
            Map<Item, EntityType<ChestMinecart>> entityRenderers = content.getChestMinecartAndTypes().stream().map(entry -> Map.entry((ChestMinecartItem)((Object)((Object)((Object)((NamedValue)entry.getKey()).getValue()))), (EntityType)((NamedValue)entry.getValue()).getValue())).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
            event.registerItem((IClientItemExtensions)new ChestCartClientExtensions(entityRenderers), (Item[])content.getChestMinecartAndTypes().stream().map(Map.Entry::getKey).map(NamedValue::getValue).toArray(Item[]::new));
        });
    }
}

