/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.DSL;
import compasses.expandedstorage.api.EsChestType;
import compasses.expandedstorage.impl.block.AbstractChestBlock;
import compasses.expandedstorage.impl.block.BarrelBlock;
import compasses.expandedstorage.impl.block.ChestBlock;
import compasses.expandedstorage.impl.block.CopperBarrelBlock;
import compasses.expandedstorage.impl.block.CopperMiniStorageBlock;
import compasses.expandedstorage.impl.block.MiniStorageBlock;
import compasses.expandedstorage.impl.block.MossChestBlock;
import compasses.expandedstorage.impl.block.entity.BarrelBlockEntity;
import compasses.expandedstorage.impl.block.entity.ChestBlockEntity;
import compasses.expandedstorage.impl.block.entity.MiniStorageBlockEntity;
import compasses.expandedstorage.impl.block.entity.OldChestBlockEntity;
import compasses.expandedstorage.impl.block.strategies.ItemAccess;
import compasses.expandedstorage.impl.block.strategies.Lockable;
import compasses.expandedstorage.impl.item.BlockMutatorBehaviour;
import compasses.expandedstorage.impl.item.ChestMinecartItem;
import compasses.expandedstorage.impl.item.EntityInteractableItem;
import compasses.expandedstorage.impl.item.MutationMode;
import compasses.expandedstorage.impl.item.MutatorData;
import compasses.expandedstorage.impl.item.StorageConversionKit;
import compasses.expandedstorage.impl.item.StorageMutator;
import compasses.expandedstorage.impl.item.ToolUsageResult;
import compasses.expandedstorage.impl.misc.CommonPlatformHelper;
import compasses.expandedstorage.impl.misc.ESDataComponents;
import compasses.expandedstorage.impl.misc.Tier;
import compasses.expandedstorage.impl.misc.Utils;
import compasses.expandedstorage.impl.recipe.BlockConversionRecipe;
import compasses.expandedstorage.impl.recipe.ConversionRecipeManager;
import compasses.expandedstorage.impl.registration.Content;
import compasses.expandedstorage.impl.registration.ContentConsumer;
import compasses.expandedstorage.impl.registration.ModItems;
import compasses.expandedstorage.impl.registration.NamedValue;
import compasses.expandedstorage.impl.registration.ObjectConsumer;
import dev.compasses.expandedstorage.block.entity.BaseBlockEntity;
import dev.compasses.expandedstorage.entity.ChestMinecart;
import dev.compasses.expandedstorage.registration.ModBlocks;
import dev.compasses.expandedstorage.registration.ModEntityTypes;
import dev.compasses.expandedstorage.registration.ModStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.Nullable;

public final class CommonMain {
    public static final ResourceLocation BARREL_OBJECT_TYPE = Utils.id("barrel");
    public static final ResourceLocation CHEST_OBJECT_TYPE = Utils.id("chest");
    public static final ResourceLocation OLD_CHEST_OBJECT_TYPE = Utils.id("old_chest");
    public static final ResourceLocation MINI_STORAGE_OBJECT_TYPE = Utils.id("mini_chest");
    private static final Map<Map.Entry<Predicate<Block>, MutationMode>, BlockMutatorBehaviour> BLOCK_MUTATOR_BEHAVIOURS = new HashMap<Map.Entry<Predicate<Block>, MutationMode>, BlockMutatorBehaviour>();
    private static final Map<ResourceLocation, ResourceLocation[]> CHEST_TEXTURES = new HashMap<ResourceLocation, ResourceLocation[]>();
    private static NamedValue<BlockEntityType<ChestBlockEntity>> chestBlockEntityType;
    private static NamedValue<BlockEntityType<OldChestBlockEntity>> oldChestBlockEntityType;
    private static NamedValue<BlockEntityType<BarrelBlockEntity>> barrelBlockEntityType;
    private static NamedValue<BlockEntityType<MiniStorageBlockEntity>> miniStorageBlockEntityType;
    private static CommonPlatformHelper platformHelper;

    public static BlockEntityType<ChestBlockEntity> getChestBlockEntityType() {
        return chestBlockEntityType.getValue();
    }

    public static BlockEntityType<OldChestBlockEntity> getOldChestBlockEntityType() {
        return oldChestBlockEntityType.getValue();
    }

    public static BlockEntityType<BarrelBlockEntity> getBarrelBlockEntityType() {
        return barrelBlockEntityType.getValue();
    }

    public static BlockEntityType<MiniStorageBlockEntity> getMiniStorageBlockEntityType() {
        return miniStorageBlockEntityType.getValue();
    }

    private static void defineTierUpgradePath(List<NamedValue<Item>> items, boolean wrapTooltipManually, Tier ... tiers) {
        int numTiers = tiers.length;
        for (int fromIndex = 0; fromIndex < numTiers - 1; ++fromIndex) {
            Tier fromTier = tiers[fromIndex];
            for (int toIndex = fromIndex + 1; toIndex < numTiers; ++toIndex) {
                Tier toTier = tiers[toIndex];
                ResourceLocation itemId = Utils.id(fromTier.getId().getPath() + "_to_" + toTier.getId().getPath() + "_conversion_kit");
                Item.Properties settings = (Item.Properties)fromTier.getItemSettings().andThen(toTier.getItemSettings()).apply(new Item.Properties().stacksTo(16));
                items.add(new NamedValue<Item>(itemId, () -> new StorageConversionKit(settings, fromTier.getId(), toTier.getId(), wrapTooltipManually)));
            }
        }
    }

    public static void declareChestTextures(ResourceLocation block, ResourceLocation singleTexture, ResourceLocation leftTexture, ResourceLocation rightTexture, ResourceLocation topTexture, ResourceLocation bottomTexture, ResourceLocation frontTexture, ResourceLocation backTexture) {
        if (CHEST_TEXTURES.containsKey(block)) {
            throw new IllegalArgumentException("Tried registering chest textures for \"" + String.valueOf(block) + "\" which already has textures.");
        }
        ResourceLocation[] collection = new ResourceLocation[]{topTexture, bottomTexture, frontTexture, backTexture, leftTexture, rightTexture, singleTexture};
        CHEST_TEXTURES.put(block, collection);
    }

    public static ResourceLocation getChestTexture(ResourceLocation block, EsChestType chestType) {
        if (CHEST_TEXTURES.containsKey(block)) {
            return CHEST_TEXTURES.get(block)[chestType.ordinal()];
        }
        return MissingTextureAtlasSprite.getLocation();
    }

    private static void registerMutationBehaviour(Predicate<Block> predicate, MutationMode mode, BlockMutatorBehaviour behaviour) {
        BLOCK_MUTATOR_BEHAVIOURS.put(Map.entry(predicate, mode), behaviour);
    }

    public static BlockMutatorBehaviour getBlockMutatorBehaviour(Block block, MutationMode mode) {
        for (Map.Entry<Map.Entry<Predicate<Block>, MutationMode>, BlockMutatorBehaviour> entry : BLOCK_MUTATOR_BEHAVIOURS.entrySet()) {
            Map.Entry<Predicate<Block>, MutationMode> pair = entry.getKey();
            if (pair.getValue() != mode || !pair.getKey().test(block)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void constructContent(CommonPlatformHelper helper, Function<BaseBlockEntity, ItemAccess<?>> itemAccess, Supplier<Lockable> lockable, boolean isClient, ContentConsumer contentRegistrationConsumer, boolean manuallyWrapTooltips, BiFunction<ChestBlock, Item.Properties, BlockItem> chestItemMaker, Function<BaseBlockEntity, ItemAccess<?>> chestAccessMaker, BiFunction<Item.Properties, ResourceLocation, ChestMinecartItem> chestMinecartItemMaker, TagKey<Block> barrelTag, BiFunction<MiniStorageBlock, Item.Properties, BlockItem> miniChestItemMaker) {
        platformHelper = helper;
        Tier woodTier = new Tier(Utils.WOOD_TIER_ID, 27, UnaryOperator.identity(), UnaryOperator.identity());
        Tier copperTier = new Tier(Utils.COPPER_TIER_ID, 45, BlockBehaviour.Properties::requiresCorrectToolForDrops, UnaryOperator.identity());
        Tier ironTier = new Tier(Utils.id("iron"), 54, BlockBehaviour.Properties::requiresCorrectToolForDrops, UnaryOperator.identity());
        Tier goldTier = new Tier(Utils.id("gold"), 81, BlockBehaviour.Properties::requiresCorrectToolForDrops, UnaryOperator.identity());
        Tier diamondTier = new Tier(Utils.id("diamond"), 108, BlockBehaviour.Properties::requiresCorrectToolForDrops, UnaryOperator.identity());
        Tier obsidianTier = new Tier(Utils.id("obsidian"), 108, BlockBehaviour.Properties::requiresCorrectToolForDrops, UnaryOperator.identity());
        Tier netheriteTier = new Tier(Utils.id("netherite"), 135, BlockBehaviour.Properties::requiresCorrectToolForDrops, Item.Properties::fireResistant);
        BlockBehaviour.Properties woodSettings = BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.5f).sound(SoundType.WOOD).ignitedByLava();
        BlockBehaviour.Properties pumpkinSettings = BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.DIDGERIDOO).strength(1.0f).sound(SoundType.WOOD);
        BlockBehaviour.Properties bambooSettings = BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).strength(1.0f).sound(SoundType.BAMBOO).ignitedByLava();
        BlockBehaviour.Properties mossSettings = BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GREEN).strength(0.1f).sound(SoundType.MOSS);
        BlockBehaviour.Properties copperSettings = BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).strength(3.0f, 6.0f).sound(SoundType.COPPER);
        BlockBehaviour.Properties ironSettings = BlockBehaviour.Properties.of().mapColor(MapColor.METAL).instrument(NoteBlockInstrument.IRON_XYLOPHONE).strength(5.0f, 6.0f).sound(SoundType.METAL);
        BlockBehaviour.Properties goldSettings = BlockBehaviour.Properties.of().mapColor(MapColor.GOLD).instrument(NoteBlockInstrument.BELL).strength(3.0f, 6.0f).sound(SoundType.METAL);
        BlockBehaviour.Properties diamondSettings = BlockBehaviour.Properties.of().mapColor(MapColor.DIAMOND).strength(5.0f, 6.0f).sound(SoundType.METAL);
        BlockBehaviour.Properties obsidianSettings = BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).instrument(NoteBlockInstrument.BASEDRUM).strength(22.5f, 1200.0f);
        BlockBehaviour.Properties netheriteSettings = BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(22.5f, 1200.0f).sound(SoundType.NETHERITE_BLOCK);
        ArrayList<ResourceLocation> stats = new ArrayList<ResourceLocation>();
        Function<String, ResourceLocation> statMaker = id -> {
            ResourceLocation statId = Utils.id(id);
            stats.add(statId);
            return statId;
        };
        ArrayList<NamedValue<Item>> baseItems = new ArrayList<NamedValue<Item>>(22);
        baseItems.add(new NamedValue<Item>(Utils.id("storage_mutator"), () -> new StorageMutator(new Item.Properties().stacksTo(1))));
        CommonMain.defineTierUpgradePath(baseItems, manuallyWrapTooltips, woodTier, copperTier, ironTier, goldTier, diamondTier, obsidianTier, netheriteTier);
        ArrayList<NamedValue<ChestBlock>> chestBlocks = new ArrayList<NamedValue<ChestBlock>>(9);
        ArrayList<NamedValue<BlockItem>> chestItems = new ArrayList<NamedValue<BlockItem>>(9);
        ArrayList<NamedValue<EntityType<ChestMinecart>>> chestMinecartEntityTypes = new ArrayList<NamedValue<EntityType<ChestMinecart>>>(9);
        ArrayList<NamedValue<ChestMinecartItem>> chestMinecartItems = new ArrayList<NamedValue<ChestMinecartItem>>(9);
        ResourceLocation woodStat = statMaker.apply("open_wood_chest");
        ResourceLocation pumpkinStat = statMaker.apply("open_pumpkin_chest");
        ResourceLocation presentStat = statMaker.apply("open_present");
        ResourceLocation bambooStat = statMaker.apply("open_bamboo_chest");
        ResourceLocation mossStat = statMaker.apply("open_moss_chest");
        ResourceLocation copperStat = statMaker.apply("open_copper_chest");
        ResourceLocation ironStat = statMaker.apply("open_iron_chest");
        ResourceLocation goldStat = statMaker.apply("open_gold_chest");
        ResourceLocation diamondStat = statMaker.apply("open_diamond_chest");
        ResourceLocation netheriteStat = statMaker.apply("open_netherite_chest");
        stats.add(ModStats.INSTANCE.getOPEN_TRIAL_CHEST());
        stats.add(ModStats.INSTANCE.getOPEN_OBSIDIAN_CHEST());
        BlockBehaviour.Properties presentSettings = BlockBehaviour.Properties.of().mapColor(state -> {
            EsChestType type = (EsChestType)((Object)((Object)state.getValue(AbstractChestBlock.CURSED_CHEST_TYPE)));
            if (type == EsChestType.SINGLE) {
                return MapColor.COLOR_RED;
            }
            if (type == EsChestType.FRONT || type == EsChestType.BACK) {
                return MapColor.PLANT;
            }
            return MapColor.SNOW;
        }).strength(2.5f).sound(SoundType.WOOD);
        ObjectConsumer chestMaker = (id, stat, tier, settings) -> {
            NamedValue<ChestBlock> block = new NamedValue<ChestBlock>(id, () -> new ChestBlock((BlockBehaviour.Properties)tier.getBlockSettings().apply(settings), stat, tier.getSlotCount()));
            NamedValue<BlockItem> item = new NamedValue<BlockItem>(id, () -> (BlockItem)chestItemMaker.apply((ChestBlock)block.getValue(), (Item.Properties)tier.getItemSettings().apply(new Item.Properties())));
            ResourceLocation cartId = id.withPath(id.getPath() + "_minecart");
            NamedValue<ChestMinecartItem> cartItem = new NamedValue<ChestMinecartItem>(cartId, () -> (ChestMinecartItem)((Object)((Object)((Object)chestMinecartItemMaker.apply(new Item.Properties(), cartId)))));
            NamedValue<EntityType> cartEntityType = new NamedValue<EntityType>(cartId, () -> new EntityType((type, level) -> new ChestMinecart(type, level, (Item)cartItem.getValue(), (ChestBlock)block.getValue()), MobCategory.MISC, true, true, false, false, ImmutableSet.of(), EntityDimensions.scalable((float)0.98f, (float)0.7f), 1.0f, 8, 3, FeatureFlagSet.of()));
            chestBlocks.add(block);
            chestItems.add(item);
            chestMinecartEntityTypes.add(cartEntityType);
            chestMinecartItems.add(cartItem);
        };
        ObjectConsumer mossChestMaker = (id, stat, tier, settings) -> {
            NamedValue<ChestBlock> block = new NamedValue<ChestBlock>(id, () -> new MossChestBlock((BlockBehaviour.Properties)tier.getBlockSettings().apply(settings), stat, tier.getSlotCount()));
            NamedValue<BlockItem> item = new NamedValue<BlockItem>(id, () -> (BlockItem)chestItemMaker.apply((ChestBlock)block.getValue(), (Item.Properties)tier.getItemSettings().apply(new Item.Properties())));
            ResourceLocation cartId = id.withPath(id.getPath() + "_minecart");
            NamedValue<ChestMinecartItem> cartItem = new NamedValue<ChestMinecartItem>(cartId, () -> (ChestMinecartItem)((Object)((Object)((Object)chestMinecartItemMaker.apply(new Item.Properties(), cartId)))));
            NamedValue<EntityType> cartEntityType = new NamedValue<EntityType>(cartId, () -> new EntityType((type, level) -> new ChestMinecart(type, level, (Item)cartItem.getValue(), (ChestBlock)block.getValue()), MobCategory.MISC, true, true, false, false, ImmutableSet.of(), EntityDimensions.scalable((float)0.98f, (float)0.7f), 1.0f, 8, 3, FeatureFlagSet.of()));
            chestBlocks.add(block);
            chestItems.add(item);
            chestMinecartEntityTypes.add(cartEntityType);
            chestMinecartItems.add(cartItem);
        };
        chestMaker.apply(Utils.id("wood_chest"), woodStat, woodTier, woodSettings);
        chestMaker.apply(Utils.id("pumpkin_chest"), pumpkinStat, woodTier, pumpkinSettings);
        chestMaker.apply(Utils.id("present"), presentStat, woodTier, presentSettings);
        chestMaker.apply(Utils.id("bamboo_chest"), bambooStat, woodTier, bambooSettings);
        mossChestMaker.apply(Utils.id("moss_chest"), mossStat, woodTier, mossSettings);
        chestMaker.apply(Utils.id("copper_chest"), copperStat, copperTier, copperSettings);
        chestMaker.apply(Utils.id("iron_chest"), ironStat, ironTier, ironSettings);
        chestMaker.apply(Utils.id("gold_chest"), goldStat, goldTier, goldSettings);
        chestMaker.apply(Utils.id("diamond_chest"), diamondStat, diamondTier, diamondSettings);
        chestMaker.apply(Utils.id("obsidian_chest"), ModStats.INSTANCE.getOPEN_OBSIDIAN_CHEST(), obsidianTier, obsidianSettings);
        chestMaker.apply(Utils.id("netherite_chest"), netheriteStat, netheriteTier, netheriteSettings);
        chestBlocks.add(new NamedValue<ChestBlock>(Utils.id("trial_chest"), () -> ModBlocks.INSTANCE.getTRIAL_CHEST()));
        chestItems.add(new NamedValue<BlockItem>(Utils.id("trial_chest"), () -> dev.compasses.expandedstorage.registration.ModItems.INSTANCE.getTRIAL_CHEST()));
        chestMinecartItems.add(new NamedValue<ChestMinecartItem>(Utils.id("trial_chest_minecart"), () -> dev.compasses.expandedstorage.registration.ModItems.INSTANCE.getTRIAL_CHEST_MINECART()));
        chestMinecartEntityTypes.add(new NamedValue<EntityType>(Utils.id("trial_chest_minecart"), () -> ModEntityTypes.INSTANCE.getTRIAL_CHEST_MINECART()));
        chestBlocks.add(new NamedValue<ChestBlock>(Utils.id("metallic_obsidian_chest"), () -> ModBlocks.INSTANCE.getMETALLIC_OBSIDIAN_CHEST()));
        chestItems.add(new NamedValue<BlockItem>(Utils.id("metallic_obsidian_chest"), () -> dev.compasses.expandedstorage.registration.ModItems.INSTANCE.getMETALLIC_OBSIDIAN_CHEST()));
        chestMinecartItems.add(new NamedValue<ChestMinecartItem>(Utils.id("metallic_obsidian_chest_minecart"), () -> dev.compasses.expandedstorage.registration.ModItems.INSTANCE.getMETALLIC_OBSIDIAN_CHEST_MINECART()));
        chestMinecartEntityTypes.add(new NamedValue<EntityType>(Utils.id("metallic_obsidian_chest_minecart"), () -> ModEntityTypes.INSTANCE.getMETALLIC_OBSIDIAN_CHEST_MINECART()));
        if (isClient) {
            chestBlocks.forEach(block -> {
                String blockId = block.getName().getPath();
                CommonMain.declareChestTextures(block.getName(), Utils.id("entity/chest/" + blockId + "_single"), Utils.id("entity/chest/" + blockId + "_left"), Utils.id("entity/chest/" + blockId + "_right"), Utils.id("entity/chest/" + blockId + "_top"), Utils.id("entity/chest/" + blockId + "_bottom"), Utils.id("entity/chest/" + blockId + "_front"), Utils.id("entity/chest/" + blockId + "_back"));
            });
        }
        chestBlockEntityType = new NamedValue<BlockEntityType>(CHEST_OBJECT_TYPE, () -> BlockEntityType.Builder.of((arg_0, arg_1) -> CommonMain.lambda$constructContent$25(chestAccessMaker, (Supplier)lockable, arg_0, arg_1), (Block[])((Block[])chestBlocks.stream().map(NamedValue::getValue).toArray(ChestBlock[]::new))).build(Util.fetchChoiceType((DSL.TypeReference)References.BLOCK_ENTITY, (String)CHEST_OBJECT_TYPE.toString())));
        ArrayList<NamedValue<AbstractChestBlock>> oldChestBlocks = new ArrayList<NamedValue<AbstractChestBlock>>(6);
        ArrayList<NamedValue<BlockItem>> oldChestItems = new ArrayList<NamedValue<BlockItem>>(6);
        ResourceLocation woodStat2 = statMaker.apply("open_old_wood_chest");
        ResourceLocation copperStat2 = statMaker.apply("open_old_copper_chest");
        ResourceLocation ironStat2 = statMaker.apply("open_old_iron_chest");
        ResourceLocation goldStat2 = statMaker.apply("open_old_gold_chest");
        ResourceLocation diamondStat2 = statMaker.apply("open_old_diamond_chest");
        ResourceLocation obsidianStat = statMaker.apply("open_old_obsidian_chest");
        ResourceLocation netheriteStat2 = statMaker.apply("open_old_netherite_chest");
        ObjectConsumer chestMaker2 = (id, stat, tier, settings) -> {
            NamedValue<AbstractChestBlock> block = new NamedValue<AbstractChestBlock>(id, () -> new AbstractChestBlock((BlockBehaviour.Properties)tier.getBlockSettings().apply(settings), stat, tier.getSlotCount()));
            NamedValue<BlockItem> item = new NamedValue<BlockItem>(id, () -> new BlockItem((Block)block.getValue(), (Item.Properties)tier.getItemSettings().apply(new Item.Properties())));
            oldChestBlocks.add(block);
            oldChestItems.add(item);
        };
        chestMaker2.apply(Utils.id("old_wood_chest"), woodStat2, woodTier, woodSettings);
        chestMaker2.apply(Utils.id("old_copper_chest"), copperStat2, copperTier, copperSettings);
        chestMaker2.apply(Utils.id("old_iron_chest"), ironStat2, ironTier, ironSettings);
        chestMaker2.apply(Utils.id("old_gold_chest"), goldStat2, goldTier, goldSettings);
        chestMaker2.apply(Utils.id("old_diamond_chest"), diamondStat2, diamondTier, diamondSettings);
        chestMaker2.apply(Utils.id("old_obsidian_chest"), obsidianStat, obsidianTier, obsidianSettings);
        chestMaker2.apply(Utils.id("old_netherite_chest"), netheriteStat2, netheriteTier, netheriteSettings);
        oldChestBlockEntityType = new NamedValue<BlockEntityType>(OLD_CHEST_OBJECT_TYPE, () -> BlockEntityType.Builder.of((arg_0, arg_1) -> CommonMain.lambda$constructContent$31(chestAccessMaker, (Supplier)lockable, arg_0, arg_1), (Block[])((Block[])oldChestBlocks.stream().map(NamedValue::getValue).toArray(AbstractChestBlock[]::new))).build(Util.fetchChoiceType((DSL.TypeReference)References.BLOCK_ENTITY, (String)OLD_CHEST_OBJECT_TYPE.toString())));
        Predicate<Block> isChestBlock = b -> b instanceof AbstractChestBlock;
        CommonMain.registerMutationBehaviour(isChestBlock, MutationMode.MERGE, (context, level, state, pos, stack) -> {
            Player player = context.getPlayer();
            if (player == null) {
                return ToolUsageResult.fail();
            }
            if (state.getValue(AbstractChestBlock.CURSED_CHEST_TYPE) == EsChestType.SINGLE) {
                MutatorData data = (MutatorData)stack.get(ESDataComponents.MUTATOR_DATA);
                if (data.pos().isPresent()) {
                    BlockPos otherPos = data.pos().get();
                    BlockState otherState = level.getBlockState(otherPos);
                    BlockPos delta = otherPos.subtract((Vec3i)pos);
                    Direction direction = Direction.fromDelta((int)delta.getX(), (int)delta.getY(), (int)delta.getZ());
                    if (direction != null) {
                        if (state.getBlock() == otherState.getBlock()) {
                            if (otherState.getValue(AbstractChestBlock.CURSED_CHEST_TYPE) == EsChestType.SINGLE) {
                                if (state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) == otherState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                                    BaseBlockEntity blockEntity;
                                    boolean secondIsDinnerbone;
                                    BaseBlockEntity blockEntity2;
                                    BlockEntity blockEntity3 = level.getBlockEntity(pos);
                                    boolean firstIsDinnerbone = blockEntity3 instanceof BaseBlockEntity && (blockEntity2 = (BaseBlockEntity)blockEntity3).isDinnerbone();
                                    BlockEntity blockEntity4 = level.getBlockEntity(otherPos);
                                    boolean bl = secondIsDinnerbone = blockEntity4 instanceof BaseBlockEntity && (blockEntity = (BaseBlockEntity)blockEntity4).isDinnerbone();
                                    if (firstIsDinnerbone == secondIsDinnerbone) {
                                        if (!level.isClientSide()) {
                                            EsChestType chestType = AbstractChestBlock.getChestType((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING), direction);
                                            level.setBlockAndUpdate(pos, (BlockState)state.setValue(AbstractChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)chestType)));
                                            stack.set(ESDataComponents.MUTATOR_DATA, (Object)new MutatorData(data.mode(), Optional.empty()));
                                            player.displayClientMessage((Component)Component.translatable((String)"tooltip.expandedstorage.storage_mutator.merge_end"), true);
                                        }
                                        return ToolUsageResult.slowSuccess();
                                    }
                                    player.displayClientMessage((Component)Component.translatable((String)"tooltip.expandedstorage.storage_mutator.merge_wrong_block"), true);
                                } else {
                                    player.displayClientMessage((Component)Component.translatable((String)"tooltip.expandedstorage.storage_mutator.merge_wrong_facing"), true);
                                }
                            } else {
                                player.displayClientMessage((Component)Component.translatable((String)"tooltip.expandedstorage.storage_mutator.merge_already_double_chest"), true);
                            }
                        } else {
                            player.displayClientMessage((Component)Component.translatable((String)"tooltip.expandedstorage.storage_mutator.merge_wrong_block"), true);
                        }
                    } else {
                        player.displayClientMessage((Component)Component.translatable((String)"tooltip.expandedstorage.storage_mutator.merge_not_adjacent"), true);
                    }
                    stack.set(ESDataComponents.MUTATOR_DATA, (Object)new MutatorData(data.mode(), Optional.empty()));
                } else {
                    if (!level.isClientSide()) {
                        stack.set(ESDataComponents.MUTATOR_DATA, (Object)new MutatorData(data.mode(), Optional.of(pos)));
                        player.displayClientMessage((Component)Component.translatable((String)"tooltip.expandedstorage.storage_mutator.merge_start", (Object[])new Object[]{Utils.ALT_USE}), true);
                    }
                    return ToolUsageResult.fastSuccess();
                }
            }
            return ToolUsageResult.fail();
        });
        CommonMain.registerMutationBehaviour(isChestBlock, MutationMode.SPLIT, (context, level, state, pos, stack) -> {
            if (state.getValue(AbstractChestBlock.CURSED_CHEST_TYPE) != EsChestType.SINGLE) {
                if (!level.isClientSide()) {
                    BlockPos otherPos = pos.relative(AbstractChestBlock.getDirectionToAttached(state));
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue(AbstractChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)EsChestType.SINGLE)));
                    level.setBlockAndUpdate(otherPos, (BlockState)state.setValue(AbstractChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)EsChestType.SINGLE)));
                }
                return ToolUsageResult.slowSuccess();
            }
            return ToolUsageResult.fail();
        });
        CommonMain.registerMutationBehaviour(isChestBlock, MutationMode.ROTATE, (context, level, state, pos, stack) -> {
            if (!level.isClientSide()) {
                EsChestType chestType = (EsChestType)((Object)((Object)state.getValue(AbstractChestBlock.CURSED_CHEST_TYPE)));
                if (chestType == EsChestType.SINGLE) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getClockWise()));
                } else {
                    BlockPos otherPos = pos.relative(AbstractChestBlock.getDirectionToAttached(state));
                    BlockState otherState = level.getBlockState(otherPos);
                    if (chestType == EsChestType.TOP || chestType == EsChestType.BOTTOM) {
                        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getClockWise()));
                        level.setBlockAndUpdate(otherPos, (BlockState)otherState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getClockWise()));
                    } else {
                        level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite())).setValue(AbstractChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)((EsChestType)((Object)((Object)state.getValue(AbstractChestBlock.CURSED_CHEST_TYPE)))).getOpposite())));
                        level.setBlockAndUpdate(otherPos, (BlockState)((BlockState)otherState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite())).setValue(AbstractChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)((EsChestType)((Object)((Object)otherState.getValue(AbstractChestBlock.CURSED_CHEST_TYPE)))).getOpposite())));
                    }
                }
            }
            return ToolUsageResult.slowSuccess();
        });
        ArrayList<NamedValue<BarrelBlock>> barrelBlocks = new ArrayList<NamedValue<BarrelBlock>>(5);
        ArrayList<NamedValue<BlockItem>> barrelItems = new ArrayList<NamedValue<BlockItem>>(5);
        ResourceLocation copperStat3 = statMaker.apply("open_copper_barrel");
        ResourceLocation ironStat3 = statMaker.apply("open_iron_barrel");
        ResourceLocation goldStat3 = statMaker.apply("open_gold_barrel");
        ResourceLocation diamondStat3 = statMaker.apply("open_diamond_barrel");
        ResourceLocation obsidianStat2 = statMaker.apply("open_obsidian_barrel");
        netheriteStat = statMaker.apply("open_netherite_barrel");
        BlockBehaviour.Properties copperBarrelSettings = BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(3.0f, 6.0f).sound(SoundType.WOOD).ignitedByLava();
        BlockBehaviour.Properties ironBarrelSettings = BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(5.0f, 6.0f).sound(SoundType.WOOD).ignitedByLava();
        BlockBehaviour.Properties goldBarrelSettings = BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(3.0f, 6.0f).sound(SoundType.WOOD).ignitedByLava();
        BlockBehaviour.Properties diamondBarrelSettings = BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(5.0f, 6.0f).sound(SoundType.WOOD).ignitedByLava();
        BlockBehaviour.Properties obsidianBarrelSettings = BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(22.5f, 1200.0f).sound(SoundType.WOOD).ignitedByLava();
        BlockBehaviour.Properties netheriteBarrelSettings = BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(22.5f, 1200.0f).sound(SoundType.WOOD);
        ObjectConsumer barrelMaker = (id, stat, tier, settings) -> {
            NamedValue<BarrelBlock> block = new NamedValue<BarrelBlock>(id, () -> new BarrelBlock((BlockBehaviour.Properties)tier.getBlockSettings().apply(settings), stat, tier.getSlotCount()));
            NamedValue<BlockItem> item = new NamedValue<BlockItem>(id, () -> new BlockItem((Block)block.getValue(), (Item.Properties)tier.getItemSettings().apply(new Item.Properties())));
            barrelBlocks.add(block);
            barrelItems.add(item);
        };
        BiConsumer<ResourceLocation, WeatheringCopper.WeatherState> copperBarrelMaker = (id, weatherState) -> {
            NamedValue<BarrelBlock> block = new NamedValue<BarrelBlock>((ResourceLocation)id, () -> new CopperBarrelBlock((BlockBehaviour.Properties)copperTier.getBlockSettings().apply(copperBarrelSettings), copperStat3, copperTier.getSlotCount(), (WeatheringCopper.WeatherState)weatherState));
            NamedValue<BlockItem> item = new NamedValue<BlockItem>((ResourceLocation)id, () -> new BlockItem((Block)block.getValue(), (Item.Properties)copperTier.getItemSettings().apply(new Item.Properties())));
            barrelBlocks.add(block);
            barrelItems.add(item);
        };
        copperBarrelMaker.accept(Utils.id("copper_barrel"), WeatheringCopper.WeatherState.UNAFFECTED);
        copperBarrelMaker.accept(Utils.id("exposed_copper_barrel"), WeatheringCopper.WeatherState.EXPOSED);
        copperBarrelMaker.accept(Utils.id("weathered_copper_barrel"), WeatheringCopper.WeatherState.WEATHERED);
        copperBarrelMaker.accept(Utils.id("oxidized_copper_barrel"), WeatheringCopper.WeatherState.OXIDIZED);
        barrelMaker.apply(Utils.id("waxed_copper_barrel"), copperStat3, copperTier, copperBarrelSettings);
        barrelMaker.apply(Utils.id("waxed_exposed_copper_barrel"), copperStat3, copperTier, copperBarrelSettings);
        barrelMaker.apply(Utils.id("waxed_weathered_copper_barrel"), copperStat3, copperTier, copperBarrelSettings);
        barrelMaker.apply(Utils.id("waxed_oxidized_copper_barrel"), copperStat3, copperTier, copperBarrelSettings);
        barrelMaker.apply(Utils.id("iron_barrel"), ironStat3, ironTier, ironBarrelSettings);
        barrelMaker.apply(Utils.id("gold_barrel"), goldStat3, goldTier, goldBarrelSettings);
        barrelMaker.apply(Utils.id("diamond_barrel"), diamondStat3, diamondTier, diamondBarrelSettings);
        barrelMaker.apply(Utils.id("obsidian_barrel"), obsidianStat2, obsidianTier, obsidianBarrelSettings);
        barrelMaker.apply(Utils.id("netherite_barrel"), netheriteStat, netheriteTier, netheriteBarrelSettings);
        barrelBlockEntityType = new NamedValue<BlockEntityType>(BARREL_OBJECT_TYPE, () -> BlockEntityType.Builder.of((arg_0, arg_1) -> CommonMain.lambda$constructContent$44(itemAccess, (Supplier)lockable, arg_0, arg_1), (Block[])((Block[])barrelBlocks.stream().map(NamedValue::getValue).toArray(BarrelBlock[]::new))).build(Util.fetchChoiceType((DSL.TypeReference)References.BLOCK_ENTITY, (String)BARREL_OBJECT_TYPE.toString())));
        Predicate<Block> isUpgradableBarrelBlock = block -> block instanceof BarrelBlock || block instanceof net.minecraft.world.level.block.BarrelBlock || block.defaultBlockState().is(barrelTag);
        CommonMain.registerMutationBehaviour(isUpgradableBarrelBlock, MutationMode.ROTATE, (context, level, state, pos, stack) -> {
            if (state.hasProperty((Property)BlockStateProperties.FACING)) {
                if (!level.isClientSide()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)BlockStateProperties.FACING));
                }
                return ToolUsageResult.slowSuccess();
            }
            return ToolUsageResult.fail();
        });
        ArrayList<NamedValue<MiniStorageBlock>> miniStorageBlocks = new ArrayList<NamedValue<MiniStorageBlock>>();
        ArrayList<NamedValue<BlockItem>> miniStorageItems = new ArrayList<NamedValue<BlockItem>>();
        ResourceLocation woodChestStat = statMaker.apply("open_wood_mini_chest");
        ResourceLocation pumpkinChestStat = statMaker.apply("open_pumpkin_mini_chest");
        ResourceLocation redPresentStat = statMaker.apply("open_red_mini_present");
        ResourceLocation whitePresentStat = statMaker.apply("open_white_mini_present");
        ResourceLocation candyCanePresentStat = statMaker.apply("open_candy_cane_mini_present");
        ResourceLocation greenPresentStat = statMaker.apply("open_green_mini_present");
        ResourceLocation lavenderPresentStat = statMaker.apply("open_lavender_mini_present");
        ResourceLocation pinkAmethystPresentStat = statMaker.apply("open_pink_amethyst_mini_present");
        ResourceLocation copperChestStat = statMaker.apply("open_copper_mini_chest");
        ResourceLocation ironChestStat = statMaker.apply("open_iron_mini_chest");
        ResourceLocation goldChestStat = statMaker.apply("open_gold_mini_chest");
        ResourceLocation diamondChestStat = statMaker.apply("open_diamond_mini_chest");
        ResourceLocation obsidianChestStat = statMaker.apply("open_obsidian_mini_chest");
        ResourceLocation netheriteChestStat = statMaker.apply("open_netherite_mini_chest");
        ResourceLocation barrelStat = statMaker.apply("open_mini_barrel");
        ResourceLocation copperBarrelStat = statMaker.apply("open_copper_mini_barrel");
        ResourceLocation ironBarrelStat = statMaker.apply("open_iron_mini_barrel");
        ResourceLocation goldBarrelStat = statMaker.apply("open_gold_mini_barrel");
        ResourceLocation diamondBarrelStat = statMaker.apply("open_diamond_mini_barrel");
        ResourceLocation obsidianBarrelStat = statMaker.apply("open_obsidian_mini_barrel");
        ResourceLocation netheriteBarrelStat = statMaker.apply("open_netherite_mini_barrel");
        BlockBehaviour.Properties redPresentSettings = BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).strength(2.5f).sound(SoundType.WOOD);
        BlockBehaviour.Properties whitePresentSettings = BlockBehaviour.Properties.of().mapColor(MapColor.SNOW).strength(2.5f).sound(SoundType.WOOD);
        BlockBehaviour.Properties candyCanePresentSettings = BlockBehaviour.Properties.of().mapColor(MapColor.SNOW).strength(2.5f).sound(SoundType.WOOD);
        BlockBehaviour.Properties greenPresentSettings = BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).strength(2.5f).sound(SoundType.WOOD);
        BlockBehaviour.Properties lavenderPresentSettings = BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).strength(2.5f).sound(SoundType.WOOD);
        BlockBehaviour.Properties pinkAmethystPresentSettings = BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).strength(2.5f).sound(SoundType.WOOD);
        BlockBehaviour.Properties woodBarrelSettings = BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(2.5f).sound(SoundType.WOOD);
        BlockBehaviour.Properties copperBarrelSettings2 = BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(3.0f, 6.0f).sound(SoundType.WOOD);
        BlockBehaviour.Properties ironBarrelSettings2 = BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(5.0f, 6.0f).sound(SoundType.WOOD);
        BlockBehaviour.Properties goldBarrelSettings2 = BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(3.0f, 6.0f).sound(SoundType.WOOD);
        BlockBehaviour.Properties diamondBarrelSettings2 = BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(5.0f, 6.0f).sound(SoundType.WOOD);
        BlockBehaviour.Properties obsidianBarrelSettings2 = BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(22.5f, 1200.0f).sound(SoundType.WOOD);
        BlockBehaviour.Properties netheriteBarrelSettings2 = BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(22.5f, 1200.0f).sound(SoundType.WOOD);
        Function<Boolean, ObjectConsumer> miniStorageMaker = hasRibbon -> (id, stat, tier, settings) -> {
            NamedValue<MiniStorageBlock> block = new NamedValue<MiniStorageBlock>(id, () -> new MiniStorageBlock((BlockBehaviour.Properties)tier.getBlockSettings().apply(settings), stat, (boolean)hasRibbon));
            NamedValue<BlockItem> item = new NamedValue<BlockItem>(id, () -> (BlockItem)miniChestItemMaker.apply((MiniStorageBlock)block.getValue(), (Item.Properties)tier.getItemSettings().apply(new Item.Properties().component(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY.with((Property)MiniStorageBlock.SPARROW, (Comparable)Boolean.FALSE)))));
            miniStorageBlocks.add(block);
            miniStorageItems.add(item);
        };
        ObjectConsumer miniStorageMakerNoRibbon = miniStorageMaker.apply(false);
        ObjectConsumer miniStorageMakerRibbon = miniStorageMaker.apply(true);
        BiConsumer<ResourceLocation, WeatheringCopper.WeatherState> copperMiniBarrelMaker = (id, weatherState) -> {
            NamedValue<MiniStorageBlock> block = new NamedValue<MiniStorageBlock>((ResourceLocation)id, () -> new CopperMiniStorageBlock((BlockBehaviour.Properties)copperTier.getBlockSettings().apply(copperBarrelSettings2), copperBarrelStat, (WeatheringCopper.WeatherState)weatherState));
            NamedValue<BlockItem> item = new NamedValue<BlockItem>((ResourceLocation)id, () -> (BlockItem)miniChestItemMaker.apply((MiniStorageBlock)block.getValue(), (Item.Properties)copperTier.getItemSettings().apply(new Item.Properties().component(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY.with((Property)MiniStorageBlock.SPARROW, (Comparable)Boolean.FALSE)))));
            miniStorageBlocks.add(block);
            miniStorageItems.add(item);
        };
        miniStorageMakerNoRibbon.apply(Utils.id("vanilla_wood_mini_chest"), woodChestStat, woodTier, woodSettings);
        miniStorageMakerNoRibbon.apply(Utils.id("wood_mini_chest"), woodChestStat, woodTier, woodSettings);
        miniStorageMakerNoRibbon.apply(Utils.id("pumpkin_mini_chest"), pumpkinChestStat, woodTier, pumpkinSettings);
        miniStorageMakerRibbon.apply(Utils.id("red_mini_present"), redPresentStat, woodTier, redPresentSettings);
        miniStorageMakerRibbon.apply(Utils.id("white_mini_present"), whitePresentStat, woodTier, whitePresentSettings);
        miniStorageMakerNoRibbon.apply(Utils.id("candy_cane_mini_present"), candyCanePresentStat, woodTier, candyCanePresentSettings);
        miniStorageMakerRibbon.apply(Utils.id("green_mini_present"), greenPresentStat, woodTier, greenPresentSettings);
        miniStorageMakerRibbon.apply(Utils.id("lavender_mini_present"), lavenderPresentStat, woodTier, lavenderPresentSettings);
        miniStorageMakerRibbon.apply(Utils.id("pink_amethyst_mini_present"), pinkAmethystPresentStat, woodTier, pinkAmethystPresentSettings);
        miniStorageMakerNoRibbon.apply(Utils.id("copper_mini_chest"), copperChestStat, copperTier, copperSettings);
        miniStorageMakerNoRibbon.apply(Utils.id("iron_mini_chest"), ironChestStat, ironTier, ironSettings);
        miniStorageMakerNoRibbon.apply(Utils.id("gold_mini_chest"), goldChestStat, goldTier, goldSettings);
        miniStorageMakerNoRibbon.apply(Utils.id("diamond_mini_chest"), diamondChestStat, diamondTier, diamondSettings);
        miniStorageMakerNoRibbon.apply(Utils.id("obsidian_mini_chest"), obsidianChestStat, obsidianTier, obsidianSettings);
        miniStorageMakerNoRibbon.apply(Utils.id("netherite_mini_chest"), netheriteChestStat, netheriteTier, netheriteSettings);
        miniStorageMakerNoRibbon.apply(Utils.id("mini_barrel"), barrelStat, woodTier, woodBarrelSettings);
        copperMiniBarrelMaker.accept(Utils.id("copper_mini_barrel"), WeatheringCopper.WeatherState.UNAFFECTED);
        copperMiniBarrelMaker.accept(Utils.id("exposed_copper_mini_barrel"), WeatheringCopper.WeatherState.EXPOSED);
        copperMiniBarrelMaker.accept(Utils.id("weathered_copper_mini_barrel"), WeatheringCopper.WeatherState.WEATHERED);
        copperMiniBarrelMaker.accept(Utils.id("oxidized_copper_mini_barrel"), WeatheringCopper.WeatherState.OXIDIZED);
        miniStorageMakerNoRibbon.apply(Utils.id("waxed_copper_mini_barrel"), copperBarrelStat, copperTier, copperBarrelSettings2);
        miniStorageMakerNoRibbon.apply(Utils.id("waxed_exposed_copper_mini_barrel"), copperBarrelStat, copperTier, copperBarrelSettings2);
        miniStorageMakerNoRibbon.apply(Utils.id("waxed_weathered_copper_mini_barrel"), copperBarrelStat, copperTier, copperBarrelSettings2);
        miniStorageMakerNoRibbon.apply(Utils.id("waxed_oxidized_copper_mini_barrel"), copperBarrelStat, copperTier, copperBarrelSettings2);
        miniStorageMakerNoRibbon.apply(Utils.id("iron_mini_barrel"), ironBarrelStat, ironTier, ironBarrelSettings2);
        miniStorageMakerNoRibbon.apply(Utils.id("gold_mini_barrel"), goldBarrelStat, goldTier, goldBarrelSettings2);
        miniStorageMakerNoRibbon.apply(Utils.id("diamond_mini_barrel"), diamondBarrelStat, diamondTier, diamondBarrelSettings2);
        miniStorageMakerNoRibbon.apply(Utils.id("obsidian_mini_barrel"), obsidianBarrelStat, obsidianTier, obsidianBarrelSettings2);
        miniStorageMakerNoRibbon.apply(Utils.id("netherite_mini_barrel"), netheriteBarrelStat, netheriteTier, netheriteBarrelSettings2);
        miniStorageBlockEntityType = new NamedValue<BlockEntityType>(MINI_STORAGE_OBJECT_TYPE, () -> BlockEntityType.Builder.of((arg_0, arg_1) -> CommonMain.lambda$constructContent$56(itemAccess, (Supplier)lockable, arg_0, arg_1), (Block[])((Block[])miniStorageBlocks.stream().map(NamedValue::getValue).toArray(MiniStorageBlock[]::new))).build(Util.fetchChoiceType((DSL.TypeReference)References.BLOCK_ENTITY, (String)MINI_STORAGE_OBJECT_TYPE.toString())));
        Predicate<Block> isMiniStorage = b -> b instanceof MiniStorageBlock;
        CommonMain.registerMutationBehaviour(isMiniStorage, MutationMode.ROTATE, (context, level, state, pos, stack) -> {
            if (!level.isClientSide()) {
                level.setBlockAndUpdate(pos, state.rotate(Rotation.CLOCKWISE_90));
            }
            return ToolUsageResult.slowSuccess();
        });
        CommonMain.registerMutationBehaviour(b -> true, MutationMode.SWAP_THEME, (context, level, state, pos, stack) -> {
            BlockConversionRecipe<?> recipe = ConversionRecipeManager.INSTANCE.getBlockRecipe(state, stack);
            if (recipe != null) {
                return recipe.process(level, context.getPlayer(), stack, state, pos);
            }
            return ToolUsageResult.fail();
        });
        contentRegistrationConsumer.accept(new Content(stats, baseItems, chestBlocks, chestItems, chestMinecartEntityTypes, chestMinecartItems, chestBlockEntityType, oldChestBlocks, oldChestItems, oldChestBlockEntityType, barrelBlocks, barrelItems, barrelBlockEntityType, miniStorageBlocks, miniStorageItems, miniStorageBlockEntityType));
    }

    public static <T> void iterateNamedList(List<NamedValue<? extends T>> list, BiConsumer<ResourceLocation, T> consumer) {
        list.forEach(it -> consumer.accept(it.getName(), it.getValue()));
    }

    public static <T> Optional<ItemAccess<T>> getItemAccess(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity) {
        if (blockEntity instanceof OldChestBlockEntity) {
            OldChestBlockEntity entity = (OldChestBlockEntity)blockEntity;
            ItemAccess access = entity.getItemAccess();
            EsChestType type = (EsChestType)((Object)state.getValue(AbstractChestBlock.CURSED_CHEST_TYPE));
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            if (access.hasCachedAccess() || type == EsChestType.SINGLE) {
                return Optional.of(access);
            }
            BlockEntity blockEntity2 = level.getBlockEntity(pos.relative(AbstractChestBlock.getDirectionToAttached(type, facing)));
            if (blockEntity2 instanceof OldChestBlockEntity) {
                ItemAccess second;
                ItemAccess first;
                OldChestBlockEntity otherEntity = (OldChestBlockEntity)blockEntity2;
                ItemAccess otherAccess = otherEntity.getItemAccess();
                if (otherAccess.hasCachedAccess()) {
                    return Optional.of(otherAccess);
                }
                if (AbstractChestBlock.getBlockType(type) == DoubleBlockCombiner.BlockType.FIRST) {
                    first = access;
                    second = otherAccess;
                } else {
                    first = otherAccess;
                    second = access;
                }
                first.setOther(second);
                CommonMain.platformHelper().invalidateCapabilityCache(level, pos);
                CommonMain.platformHelper().invalidateCapabilityCache(level, otherEntity.getBlockPos());
                return Optional.of(first);
            }
        } else if (blockEntity instanceof BaseBlockEntity) {
            BaseBlockEntity entity = (BaseBlockEntity)blockEntity;
            return Optional.of(entity.getItemAccess());
        }
        return Optional.empty();
    }

    public static InteractionResult interactWithEntity(Level level, Player player, InteractionHand hand, Entity entity) {
        if (player.isSpectator() || !player.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        ItemStack handStack = player.getItemInHand(hand);
        Item item = handStack.getItem();
        if (item instanceof EntityInteractableItem) {
            EntityInteractableItem item2 = (EntityInteractableItem)item;
            if (player.getCooldowns().isOnCooldown(handStack.getItem())) {
                return InteractionResult.CONSUME;
            }
            InteractionResult result = item2.es_interactEntity(level, entity, player, hand, handStack);
            if (result == InteractionResult.FAIL) {
                result = InteractionResult.CONSUME;
            }
            return result;
        }
        return InteractionResult.PASS;
    }

    public static void generateDisplayItems(CreativeModeTab.ItemDisplayParameters itemDisplayParameters, Consumer<ItemStack> output) {
        Consumer<Item> wrap = item -> output.accept(item.getDefaultInstance());
        Consumer<Item> sparrowWrap = item -> {
            wrap.accept((Item)item);
            ItemStack stack = new ItemStack((ItemLike)item);
            stack.set(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY.with((Property)MiniStorageBlock.SPARROW, (Comparable)Boolean.TRUE));
            output.accept(stack);
        };
        for (MutationMode mode : MutationMode.values()) {
            ItemStack stack = new ItemStack((ItemLike)ModItems.STORAGE_MUTATOR);
            stack.set(ESDataComponents.MUTATOR_DATA, (Object)new MutatorData(mode, Optional.empty()));
            output.accept(stack);
        }
        ItemStack sparrowMutator = new ItemStack((ItemLike)ModItems.STORAGE_MUTATOR);
        sparrowMutator.set(ESDataComponents.MUTATOR_DATA, (Object)new MutatorData(MutationMode.SWAP_THEME, Optional.empty()));
        sparrowMutator.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Sparrow").withStyle(ChatFormatting.ITALIC));
        output.accept(sparrowMutator);
        wrap.accept(ModItems.WOOD_TO_COPPER_CONVERSION_KIT);
        wrap.accept(ModItems.WOOD_TO_IRON_CONVERSION_KIT);
        wrap.accept(ModItems.WOOD_TO_GOLD_CONVERSION_KIT);
        wrap.accept(ModItems.WOOD_TO_DIAMOND_CONVERSION_KIT);
        wrap.accept(ModItems.WOOD_TO_OBSIDIAN_CONVERSION_KIT);
        wrap.accept(ModItems.WOOD_TO_NETHERITE_CONVERSION_KIT);
        wrap.accept(ModItems.COPPER_TO_IRON_CONVERSION_KIT);
        wrap.accept(ModItems.COPPER_TO_GOLD_CONVERSION_KIT);
        wrap.accept(ModItems.COPPER_TO_DIAMOND_CONVERSION_KIT);
        wrap.accept(ModItems.COPPER_TO_OBSIDIAN_CONVERSION_KIT);
        wrap.accept(ModItems.COPPER_TO_NETHERITE_CONVERSION_KIT);
        wrap.accept(ModItems.IRON_TO_GOLD_CONVERSION_KIT);
        wrap.accept(ModItems.IRON_TO_DIAMOND_CONVERSION_KIT);
        wrap.accept(ModItems.IRON_TO_OBSIDIAN_CONVERSION_KIT);
        wrap.accept(ModItems.IRON_TO_NETHERITE_CONVERSION_KIT);
        wrap.accept(ModItems.GOLD_TO_DIAMOND_CONVERSION_KIT);
        wrap.accept(ModItems.GOLD_TO_OBSIDIAN_CONVERSION_KIT);
        wrap.accept(ModItems.GOLD_TO_NETHERITE_CONVERSION_KIT);
        wrap.accept(ModItems.DIAMOND_TO_OBSIDIAN_CONVERSION_KIT);
        wrap.accept(ModItems.DIAMOND_TO_NETHERITE_CONVERSION_KIT);
        wrap.accept(ModItems.OBSIDIAN_TO_NETHERITE_CONVERSION_KIT);
        wrap.accept((Item)ModItems.WOOD_CHEST);
        wrap.accept((Item)ModItems.PUMPKIN_CHEST);
        wrap.accept((Item)ModItems.PRESENT);
        wrap.accept((Item)ModItems.BAMBOO_CHEST);
        wrap.accept((Item)ModItems.MOSS_CHEST);
        wrap.accept((Item)ModItems.COPPER_CHEST);
        wrap.accept((Item)dev.compasses.expandedstorage.registration.ModItems.INSTANCE.getTRIAL_CHEST());
        wrap.accept((Item)ModItems.IRON_CHEST);
        wrap.accept((Item)ModItems.GOLD_CHEST);
        wrap.accept((Item)ModItems.DIAMOND_CHEST);
        wrap.accept((Item)ModItems.OBSIDIAN_CHEST);
        wrap.accept((Item)dev.compasses.expandedstorage.registration.ModItems.INSTANCE.getMETALLIC_OBSIDIAN_CHEST());
        wrap.accept((Item)ModItems.NETHERITE_CHEST);
        wrap.accept(ModItems.WOOD_CHEST_MINECART);
        wrap.accept(ModItems.PUMPKIN_CHEST_MINECART);
        wrap.accept(ModItems.PRESENT_MINECART);
        wrap.accept(ModItems.BAMBOO_CHEST_MINECART);
        wrap.accept(ModItems.MOSS_CHEST_MINECART);
        wrap.accept(ModItems.COPPER_CHEST_MINECART);
        wrap.accept(dev.compasses.expandedstorage.registration.ModItems.INSTANCE.getTRIAL_CHEST_MINECART());
        wrap.accept(ModItems.IRON_CHEST_MINECART);
        wrap.accept(ModItems.GOLD_CHEST_MINECART);
        wrap.accept(ModItems.DIAMOND_CHEST_MINECART);
        wrap.accept(ModItems.OBSIDIAN_CHEST_MINECART);
        wrap.accept(dev.compasses.expandedstorage.registration.ModItems.INSTANCE.getMETALLIC_OBSIDIAN_CHEST_MINECART());
        wrap.accept(ModItems.NETHERITE_CHEST_MINECART);
        wrap.accept((Item)ModItems.OLD_WOOD_CHEST);
        wrap.accept((Item)ModItems.OLD_COPPER_CHEST);
        wrap.accept((Item)ModItems.OLD_IRON_CHEST);
        wrap.accept((Item)ModItems.OLD_GOLD_CHEST);
        wrap.accept((Item)ModItems.OLD_DIAMOND_CHEST);
        wrap.accept((Item)ModItems.OLD_OBSIDIAN_CHEST);
        wrap.accept((Item)ModItems.OLD_NETHERITE_CHEST);
        wrap.accept((Item)ModItems.COPPER_BARREL);
        wrap.accept((Item)ModItems.EXPOSED_COPPER_BARREL);
        wrap.accept((Item)ModItems.WEATHERED_COPPER_BARREL);
        wrap.accept((Item)ModItems.OXIDIZED_COPPER_BARREL);
        wrap.accept((Item)ModItems.WAXED_COPPER_BARREL);
        wrap.accept((Item)ModItems.WAXED_EXPOSED_COPPER_BARREL);
        wrap.accept((Item)ModItems.WAXED_WEATHERED_COPPER_BARREL);
        wrap.accept((Item)ModItems.WAXED_OXIDIZED_COPPER_BARREL);
        wrap.accept((Item)ModItems.IRON_BARREL);
        wrap.accept((Item)ModItems.GOLD_BARREL);
        wrap.accept((Item)ModItems.DIAMOND_BARREL);
        wrap.accept((Item)ModItems.OBSIDIAN_BARREL);
        wrap.accept((Item)ModItems.NETHERITE_BARREL);
        sparrowWrap.accept((Item)ModItems.VANILLA_WOOD_MINI_CHEST);
        sparrowWrap.accept((Item)ModItems.WOOD_MINI_CHEST);
        sparrowWrap.accept((Item)ModItems.PUMPKIN_MINI_CHEST);
        sparrowWrap.accept((Item)ModItems.RED_MINI_PRESENT);
        sparrowWrap.accept((Item)ModItems.WHITE_MINI_PRESENT);
        sparrowWrap.accept((Item)ModItems.CANDY_CANE_MINI_PRESENT);
        sparrowWrap.accept((Item)ModItems.GREEN_MINI_PRESENT);
        sparrowWrap.accept((Item)ModItems.LAVENDER_MINI_PRESENT);
        sparrowWrap.accept((Item)ModItems.PINK_AMETHYST_MINI_PRESENT);
        sparrowWrap.accept((Item)ModItems.COPPER_MINI_CHEST);
        sparrowWrap.accept((Item)ModItems.IRON_MINI_CHEST);
        sparrowWrap.accept((Item)ModItems.GOLD_MINI_CHEST);
        sparrowWrap.accept((Item)ModItems.DIAMOND_MINI_CHEST);
        sparrowWrap.accept((Item)ModItems.OBSIDIAN_MINI_CHEST);
        sparrowWrap.accept((Item)ModItems.NETHERITE_MINI_CHEST);
        sparrowWrap.accept((Item)ModItems.MINI_BARREL);
        sparrowWrap.accept((Item)ModItems.COPPER_MINI_BARREL);
        sparrowWrap.accept((Item)ModItems.EXPOSED_COPPER_MINI_BARREL);
        sparrowWrap.accept((Item)ModItems.WEATHERED_COPPER_MINI_BARREL);
        sparrowWrap.accept((Item)ModItems.OXIDIZED_COPPER_MINI_BARREL);
        sparrowWrap.accept((Item)ModItems.WAXED_COPPER_MINI_BARREL);
        sparrowWrap.accept((Item)ModItems.WAXED_EXPOSED_COPPER_MINI_BARREL);
        sparrowWrap.accept((Item)ModItems.WAXED_WEATHERED_COPPER_MINI_BARREL);
        sparrowWrap.accept((Item)ModItems.WAXED_OXIDIZED_COPPER_MINI_BARREL);
        sparrowWrap.accept((Item)ModItems.IRON_MINI_BARREL);
        sparrowWrap.accept((Item)ModItems.GOLD_MINI_BARREL);
        sparrowWrap.accept((Item)ModItems.DIAMOND_MINI_BARREL);
        sparrowWrap.accept((Item)ModItems.OBSIDIAN_MINI_BARREL);
        sparrowWrap.accept((Item)ModItems.NETHERITE_MINI_BARREL);
    }

    public static CommonPlatformHelper platformHelper() {
        return platformHelper;
    }

    private static /* synthetic */ MiniStorageBlockEntity lambda$constructContent$56(Function itemAccess, Supplier lockable, BlockPos pos, BlockState state) {
        return new MiniStorageBlockEntity(CommonMain.getMiniStorageBlockEntityType(), pos, state, itemAccess, lockable);
    }

    private static /* synthetic */ BarrelBlockEntity lambda$constructContent$44(Function itemAccess, Supplier lockable, BlockPos pos, BlockState state) {
        return new BarrelBlockEntity(CommonMain.getBarrelBlockEntityType(), pos, state, itemAccess, lockable);
    }

    private static /* synthetic */ OldChestBlockEntity lambda$constructContent$31(Function chestAccessMaker, Supplier lockable, BlockPos pos, BlockState state) {
        return new OldChestBlockEntity(CommonMain.getOldChestBlockEntityType(), pos, state, chestAccessMaker, lockable);
    }

    private static /* synthetic */ ChestBlockEntity lambda$constructContent$25(Function chestAccessMaker, Supplier lockable, BlockPos pos, BlockState state) {
        return new ChestBlockEntity(CommonMain.getChestBlockEntityType(), pos, state, chestAccessMaker, lockable);
    }
}

