/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.api;

import compasses.expandedstorage.api.EsChestType;
import compasses.expandedstorage.impl.block.AbstractChestBlock;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public final class ExpandedStorageAccessors {
    private ExpandedStorageAccessors() {
        throw new IllegalStateException("Should not be instantiated.");
    }

    public static Optional<EsChestType> getChestType(BlockState state) {
        if (state.hasProperty(AbstractChestBlock.CURSED_CHEST_TYPE)) {
            return Optional.of((EsChestType)((Object)state.getValue(AbstractChestBlock.CURSED_CHEST_TYPE)));
        }
        return Optional.empty();
    }

    public static Optional<Direction> getAttachedChestDirection(BlockState state) {
        EsChestType type;
        if (state.hasProperty(AbstractChestBlock.CURSED_CHEST_TYPE) && state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING) && (type = (EsChestType)((Object)state.getValue(AbstractChestBlock.CURSED_CHEST_TYPE))) != EsChestType.SINGLE) {
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            return Optional.of(AbstractChestBlock.getDirectionToAttached(type, facing));
        }
        return Optional.empty();
    }

    public static Optional<BlockState> chestWithType(BlockState original, EsChestType type) {
        if (original.hasProperty(AbstractChestBlock.CURSED_CHEST_TYPE)) {
            return Optional.of((BlockState)original.setValue(AbstractChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)type)));
        }
        return Optional.empty();
    }
}

