/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.packingtape;

import dev.gigaherz.packingtape.ConfigValues;
import dev.gigaherz.packingtape.tape.ContainedBlockData;
import dev.gigaherz.packingtape.tape.PackagedBlock;
import dev.gigaherz.packingtape.tape.PackagedBlockEntity;
import dev.gigaherz.packingtape.tape.TapeItem;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="packingtape")
public class PackingTapeMod {
    public static final String MODID = "packingtape";
    private static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"packingtape");
    private static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"packingtape");
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"packingtape");
    private static final DeferredRegister<DataComponentType<?>> DATA_COMPONENTS = DeferredRegister.create((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"packingtape");
    public static final DeferredBlock<PackagedBlock> PACKAGED_BLOCK = BLOCKS.register("packaged_block", () -> new PackagedBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOL).strength(0.5f, 0.5f).sound(SoundType.WOOD)));
    public static final DeferredItem<BlockItem> PACKAGED_BLOCK_ITEM = ITEMS.register(PACKAGED_BLOCK.getId().getPath(), () -> new BlockItem((Block)PACKAGED_BLOCK.get(), new Item.Properties().stacksTo(16)));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<PackagedBlockEntity>> PACKAGED_BLOCK_ENTITY = BLOCK_ENTITIES.register(PACKAGED_BLOCK.getId().getPath(), () -> BlockEntityType.Builder.of(PackagedBlockEntity::new, (Block[])new Block[]{(Block)PACKAGED_BLOCK.get()}).build(null));
    public static final DeferredItem<TapeItem> TAPE = ITEMS.register("tape", () -> new TapeItem(new Item.Properties().stacksTo(16)));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<ContainedBlockData>> CONTAINED_BLOCK = DATA_COMPONENTS.register("contained_block", () -> DataComponentType.builder().persistent(ContainedBlockData.CODEC).networkSynchronized(ContainedBlockData.STREAM_CODEC).build());

    public PackingTapeMod(ModContainer thisContainer, IEventBus modEventBus) {
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        BLOCK_ENTITIES.register(modEventBus);
        DATA_COMPONENTS.register(modEventBus);
        modEventBus.addListener(this::modConfigLoad);
        modEventBus.addListener(this::modConfigReload);
        modEventBus.addListener(this::gatherData);
        modEventBus.addListener(this::addItemsToTabs);
        thisContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ConfigValues.SERVER_SPEC);
    }

    private void addItemsToTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept(TAPE);
            event.accept(PACKAGED_BLOCK_ITEM, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        }
    }

    private void gatherData(GatherDataEvent event) {
        DataGen.gatherData(event);
    }

    public void modConfigLoad(ModConfigEvent.Loading event) {
        this.refreshConfig((ModConfigEvent)event);
    }

    public void modConfigReload(ModConfigEvent.Reloading event) {
        this.refreshConfig((ModConfigEvent)event);
    }

    private void refreshConfig(ModConfigEvent event) {
        if (event.getConfig().getSpec() == ConfigValues.SERVER_SPEC) {
            ConfigValues.bake();
        }
    }

    public static ResourceLocation location(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public static class DataGen {
        public static void gatherData(GatherDataEvent event) {
            DataGenerator gen = event.getGenerator();
            gen.addProvider(event.includeServer(), (DataProvider)Loot.create(gen.getPackOutput(), event.getLookupProvider()));
            gen.addProvider(event.includeServer(), (DataProvider)new Recipes(gen, event.getLookupProvider()));
        }

        private static class Loot {
            private Loot() {
            }

            public static LootTableProvider create(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookup) {
                return new LootTableProvider(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(BlockTables::new, LootContextParamSets.BLOCK)), lookup);
            }

            public static class BlockTables
            extends BlockLootSubProvider {
                public BlockTables(HolderLookup.Provider provider) {
                    super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
                }

                protected void generate() {
                    this.add((Block)PACKAGED_BLOCK.get(), this::dropWithPackagedContents);
                }

                protected LootTable.Builder dropWithPackagedContents(Block block) {
                    return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include((DataComponentType)CONTAINED_BLOCK.get())))));
                }

                protected Iterable<Block> getKnownBlocks() {
                    return BuiltInRegistries.BLOCK.entrySet().stream().filter(e -> ((ResourceKey)e.getKey()).location().getNamespace().equals(PackingTapeMod.MODID)).map(Map.Entry::getValue).collect(Collectors.toList());
                }
            }
        }

        private static class Recipes
        extends RecipeProvider
        implements DataProvider,
        IConditionBuilder {
            public Recipes(DataGenerator gen, CompletableFuture<HolderLookup.Provider> lookupProvider) {
                super(gen.getPackOutput(), lookupProvider);
            }

            protected void buildRecipes(RecipeOutput consumer) {
                ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)TAPE.get())).requires(Tags.Items.SLIME_BALLS).requires(Tags.Items.STRINGS).requires((ItemLike)Items.PAPER).unlockedBy("has_slime_ball", Recipes.has((ItemLike)Items.SLIME_BALL)).save(consumer);
            }
        }
    }
}

