/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.NativeJSON;
import dev.latvian.mods.rhino.NativeNumber;
import dev.latvian.mods.rhino.NativeString;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.Wrapper;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;

public class NativeGSON
extends NativeJSON {
    private final Gson gson = new GsonBuilder().serializeNulls().disableHtmlEscaping().setLenient().create();

    static void initGSON(Scriptable scope, boolean sealed, Context cx) {
        NativeGSON obj = new NativeGSON();
        obj.activatePrototypeMap(3);
        obj.setPrototype(NativeGSON.getObjectPrototype(scope, cx));
        obj.setParentScope(scope);
        if (sealed) {
            obj.sealObject(cx);
        }
        NativeGSON.defineProperty(scope, "JSON", obj, 2, cx);
    }

    public static JsonElement stringify0(Context cx, Object v) {
        Object object = v;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonElement.class, Boolean.class, CharSequence.class, Number.class, NativeString.class, NativeNumber.class, Map.class, Iterable.class}, (Object)object, n)) {
            case -1 -> JsonNull.INSTANCE;
            case 0 -> {
                JsonElement json = (JsonElement)object;
                yield json;
            }
            case 1 -> {
                Boolean b = (Boolean)object;
                yield new JsonPrimitive(b);
            }
            case 2 -> {
                CharSequence ignore = (CharSequence)object;
                yield new JsonPrimitive(v.toString());
            }
            case 3 -> {
                Number n = (Number)object;
                yield new JsonPrimitive(n);
            }
            case 4 -> {
                NativeString ignore = (NativeString)object;
                yield new JsonPrimitive(ScriptRuntime.toString(cx, v));
            }
            case 5 -> {
                NativeNumber ignore = (NativeNumber)object;
                yield new JsonPrimitive((Number)ScriptRuntime.toNumber(cx, v));
            }
            case 6 -> {
                Map map = (Map)object;
                JsonObject json = new JsonObject();
                for (Map.Entry entry : map.entrySet()) {
                    json.add(entry.getKey().toString(), NativeGSON.stringify0(cx, entry.getValue()));
                }
                yield json;
            }
            case 7 -> {
                Iterable itr = (Iterable)object;
                JsonArray json = new JsonArray();
                for (Object o : itr) {
                    json.add(NativeGSON.stringify0(cx, o));
                }
                yield json;
            }
            default -> {
                JsonArray json = new JsonArray();
                cx.getCachedClassStorage(false).get(Wrapper.unwrapped(v).getClass()).getDebugInfo().forEach(arg_0 -> ((JsonArray)json).add(arg_0));
                yield json;
            }
        };
    }

    private NativeGSON() {
    }

    @Override
    public String stringifyJSON(Object value, Object replacer, Object space, Context cx) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter((Writer)stringWriter);
        String indent = null;
        if (space instanceof NativeNumber) {
            space = ScriptRuntime.toNumber(cx, space);
        } else if (space instanceof NativeString) {
            space = ScriptRuntime.toString(cx, space);
        }
        if (space instanceof Number) {
            int gapLength = (int)ScriptRuntime.toInteger(cx, space);
            indent = (gapLength = Math.min(10, gapLength)) > 0 ? " ".repeat(gapLength) : "";
        } else if (space instanceof String && (indent = (String)space).length() > 10) {
            indent = indent.substring(0, 10);
        }
        writer.setIndent(Objects.requireNonNullElse(indent, ""));
        this.gson.toJson(NativeGSON.stringify0(cx, value), writer);
        return stringWriter.toString();
    }
}

