/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.player;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.world.level.Level;

public class FakePlayer
extends ServerPlayer {
    public FakePlayer(ServerLevel level, BlockPos blockPos) {
        super(level.getServer(), level, new GameProfile(UUID.randomUUID(), "FakePlayer"), ClientInformation.createDefault());
        this.getAdvancements().stopListening();
        this.setPos(blockPos.getX(), blockPos.getY(), blockPos.getZ());
    }

    public static boolean isInvalidFakePlayer(FakePlayer fakePlayer) {
        return !(fakePlayer instanceof FakePlayer) || !fakePlayer.isAlive();
    }

    public FakePlayer updatePosition(ServerLevel level, BlockPos blockPos) {
        if (this.level() != level) {
            this.setLevel((Level)level);
        } else if (this.blockPosition().distSqr((Vec3i)blockPos) > 1.0) {
            this.setPos(blockPos.getX(), blockPos.getY(), blockPos.getZ());
        }
        return this;
    }

    public void displayClientMessage(Component chatComponent, boolean actionBar) {
    }

    public void awardStat(Stat stat, int increment) {
    }

    public void tick() {
    }

    public void doTick() {
    }
}

